/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.SimpleDataListEntry;
import de.mrjulsen.crn.client.gui.widgets.options.SimpleDataListNewEntry;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.WidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DataListContainer<T, S>
extends WidgetContainer {
    private static final int BORDER_WIDTH = 2;
    private final Screen parent;
    private final OptionEntry<?> parentEntry;
    private T data;
    private int entriesHeight;
    private int addNewEntryHeight;
    private int contentHeight;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private boolean renderBackground = true;
    private boolean bordered = true;
    private final Collection<DLTooltip> tooltips = new ArrayList<DLTooltip>();
    private final Function<T, Iterator<S>> onGetData;
    private final BiFunction<S, SimpleDataListEntry<T, S>, String> onCreateEntry;
    private final Consumer<DataListContainer<T, S>> onContainerSizeChanged;
    private final BiConsumer<T, SimpleDataListNewEntry<T, S>> createNewEntry;
    private String filterText = "";
    private BiPredicate<S, Supplier<String>> filter;

    public DataListContainer(OptionEntry<?> parentEntry, int x, int y, int width, T initialData, Function<T, Iterator<S>> dataIterator, BiFunction<S, SimpleDataListEntry<T, S>, String> onCreateEntry, BiConsumer<T, SimpleDataListNewEntry<T, S>> createNewEntry, Consumer<DataListContainer<T, S>> onContainerSizeChanged) {
        super(x, y, width, 100);
        this.parent = parentEntry.getParentScreen();
        this.parentEntry = parentEntry;
        this.onGetData = dataIterator;
        this.onCreateEntry = onCreateEntry;
        this.onContainerSizeChanged = onContainerSizeChanged;
        this.createNewEntry = createNewEntry;
        this.displayData(initialData, false);
    }

    public void setPadding(int top, int right, int bottom, int left) {
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.paddingLeft = left;
        this.displayData(this.data, false);
    }

    public void setFilter(BiPredicate<S, Supplier<String>> filter) {
        this.filter = filter;
        this.displayData(this.data, false);
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public boolean isRenderBackground() {
        return this.renderBackground;
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    public int displayData(T data) {
        return this.displayData(data, true);
    }

    private int displayData(final T data, boolean notifySizeChanged) {
        this.clearWidgets();
        this.tooltips.clear();
        this.data = data;
        this.contentHeight = this.paddingTop + 2;
        this.entriesHeight = 0;
        this.addNewEntryHeight = 0;
        Single.MutableSingle searchBox = new Single.MutableSingle(null);
        DLUtils.doIfNotNull(this.filter, x -> {
            searchBox.setFirst((Object)((DLEditBox)this.addRenderableWidget((GuiEventListener)new DLEditBox(this.font, this.x() + 2 + this.paddingLeft + 1, this.y() + 2 + this.contentHeight, this.width() - 4 - this.paddingLeft - this.paddingRight - 2, 14, (Component)TextUtils.empty()){

                public boolean m_7933_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
                    if (code == 257) {
                        DataListContainer.this.filterText = this.m_94155_();
                        DataListContainer.this.displayData(data, true);
                        return true;
                    }
                    return super.m_7933_(code, p_keyPressed_2_, p_keyPressed_3_);
                }
            })));
            ((DLEditBox)searchBox.getFirst()).withHint(DragonLib.TEXT_SEARCH);
            ((DLEditBox)searchBox.getFirst()).m_94144_(this.filterText);
            int h = ((DLEditBox)searchBox.getFirst()).height() + 4;
            this.contentHeight += h;
            this.entriesHeight += h;
            this.addNewEntryHeight += h;
        });
        Iterator<S> content = this.onGetData.apply(data);
        while (content.hasNext()) {
            S current = content.next();
            if (this.filter != null && !this.filter.test(current, () -> searchBox.getFirst() == null ? "" : ((DLEditBox)searchBox.getFirst()).m_94155_())) continue;
            SimpleDataListEntry entry = (SimpleDataListEntry)this.addRenderableWidget((GuiEventListener)new SimpleDataListEntry(this, this.x() + 2 + this.paddingLeft, this.y() + this.contentHeight, this.width() - 4 - this.paddingLeft - this.paddingRight, current));
            entry.setText(this.onCreateEntry.apply(current, entry));
            entry.buildInternal();
            this.contentHeight += entry.height();
            this.entriesHeight += entry.height();
        }
        DLUtils.doIfNotNull(this.createNewEntry, x -> {
            SimpleDataListNewEntry entry = (SimpleDataListNewEntry)this.addRenderableWidget((GuiEventListener)new SimpleDataListNewEntry(this, this.x() + 2 + this.paddingLeft, this.y() + this.contentHeight, this.width() - 4 - this.paddingLeft - this.paddingRight));
            this.createNewEntry.accept(data, entry);
            entry.buildInternal();
            this.contentHeight += entry.height();
            this.addNewEntryHeight = entry.height();
        });
        this.contentHeight += this.paddingBottom + 2;
        this.set_height(this.contentHeight);
        if (notifySizeChanged) {
            this.onContainerSizeChanged.accept(this);
        }
        return this.height();
    }

    public Screen getParentScreen() {
        return this.parent;
    }

    public OptionEntry<?> getParentEntry() {
        return this.parentEntry;
    }

    public T getData() {
        return this.data;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isRenderBackground()) {
            if (this.isBordered()) {
                if (this.createNewEntry == null) {
                    CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.LIGHT);
                } else {
                    CreateDynamicWidgets.renderDuoShadeWidget(graphics, this.x(), this.y(), this.width(), 2 + this.paddingTop + this.entriesHeight, CreateDynamicWidgets.ColorShade.LIGHT, 2 + this.paddingBottom + this.addNewEntryHeight, CreateDynamicWidgets.ColorShade.DARK);
                }
            } else {
                GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)CreateDynamicWidgets.ColorShade.LIGHT.getColor());
                if (this.createNewEntry != null) {
                    GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)(this.y() + 2 + this.paddingTop + this.entriesHeight), (int)this.width(), (int)(2 + this.paddingBottom + this.addNewEntryHeight), (int)CreateDynamicWidgets.ColorShade.DARK.getColor());
                }
            }
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public Collection<DLTooltip> getTooltips() {
        return this.tooltips;
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        this.tooltips.stream().forEach(x -> x.render(this.parent, graphics, mouseX, mouseY));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

