/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.flyouts;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.CRNListBox;
import de.mrjulsen.crn.client.gui.widgets.FlatCheckBox;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class FlyoutTrainGroupsWidget<T extends GuiEventListener & Renderable>
extends AbstractFlyoutWidget<T> {
    private final MutableComponent textTrainGroups = TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups").m_130940_(ChatFormatting.BOLD);
    private final UserSettings settings;
    private final CRNListBox<TrainGroup, FlatCheckBox> trainGroups;
    private final Supplier<UserSettings.UserSetting<Set<String>>> getUserSetting;

    public FlyoutTrainGroupsWidget(DLScreen screen, AbstractFlyoutWidget.FlyoutPointer pointer, CreateDynamicWidgets.ColorShade pointerShade, Consumer<T> addRenderableWidgetFunc, UserSettings settings, Supplier<UserSettings.UserSetting<Set<String>>> getUserSetting, Consumer<GuiEventListener> removeWidgetFunc) {
        super(screen, 1, 120, pointer, pointerShade, addRenderableWidgetFunc, removeWidgetFunc);
        this.set_width(Math.max(150, this.font.m_92852_((FormattedText)this.textTrainGroups) + 18 + 16 + 10 + 14));
        this.settings = settings;
        this.getUserSetting = getUserSetting;
        int top = this.getContentArea().getY() + 21;
        int contentHeight = this.getContentArea().getHeight() - 21 - 2;
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((Screen)screen, this.getContentArea().getX() + this.getContentArea().getWidth() - 7, top, contentHeight, GuiAreaDefinition.of((Screen)screen));
        this.trainGroups = (CRNListBox)this.addRenderableWidget((GuiEventListener)new CRNListBox((Screen)screen, this.getContentArea().getX() + 2, top, this.getContentArea().getWidth() - 4, contentHeight, (DLAbstractScrollBar<?>)scrollBar));
        this.addRenderableWidget((GuiEventListener)scrollBar);
        DLIconButton resetBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, ModGuiIcons.REFRESH.getAsSprite(16, 16), this.getContentArea().getX() + this.getContentArea().getWidth() - 18 - 2, this.getContentArea().getY() + 2, (Component)TextUtils.empty(), b -> {
            ((UserSettings.UserSetting)getUserSetting.get()).setToDefault();
            settings.clientSave(() -> this.reload(null));
        }));
        resetBtn.setBackColor(0);
    }

    @Override
    public void renderFlyoutContent(Graphics graphics, int mouseX, int mouseY, float partialTicks, GuiAreaDefinition contentArea) {
        super.renderFlyoutContent(graphics, mouseX, mouseY, partialTicks, contentArea);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(contentArea.getX() + 8), (int)(contentArea.getY() + 8), (FormattedText)this.textTrainGroups, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    @Override
    public void open(IDragonLibWidget parent) {
        this.reload(() -> super.open(parent));
    }

    private void reload(Runnable andThen) {
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_TRAIN_GROUPS, groups -> {
            this.trainGroups.displayData(new ArrayList(groups.stream().sorted((a, b) -> a.getGroupName().compareToIgnoreCase(b.getGroupName())).toList()), group -> {
                FlatCheckBox cb = new FlatCheckBox(0, 0, 0, group.getGroupName(), this.getUserSetting.get().getValue().stream().noneMatch(x -> x.equals(group.getGroupName())), b -> {});
                return cb;
            });
            DLUtils.doIfNotNull((Object)andThen, x -> x.run());
        });
    }

    @Override
    public void close() {
        DLUtils.doIfNotNull((Object)this.settings, x -> {
            this.getUserSetting.get().setValue(new HashSet(this.trainGroups.getEntries().stream().filter(a -> !((FlatCheckBox)((Object)((Object)((Object)a.getKey())))).isChecked()).map(a -> (TrainGroup)a.getValue()).map(a -> a.getGroupName()).collect(Collectors.toSet())));
            x.clientSave(() -> super.close());
        });
    }
}

