/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.widgets.SavedRouteWidget;
import de.mrjulsen.crn.data.ISaveableNavigatorData;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLRenderable;
import de.mrjulsen.mcdragonlib.client.gui.widgets.ScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SavedRoutesViewer
extends ScrollableWidgetContainer {
    private final Screen parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;
    private List<? extends ISaveableNavigatorData> data = List.of();

    public SavedRoutesViewer(Screen parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.updateMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public Screen getParent() {
        return this.parent;
    }

    public void refresh() {
        this.displayRoutes(this.data);
    }

    public void displayRoutes(List<? extends ISaveableNavigatorData> data) {
        this.data = data;
        Collections.sort(data, Comparator.comparing(x -> ((ISaveableNavigatorData)x).customGroup() == null ? null : (String)((ISaveableNavigatorData)x).customGroup().getFirst(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparingLong(x -> ((ISaveableNavigatorData)x).dayOrderValue()).thenComparingLong(x -> ((ISaveableNavigatorData)x).timeOrderValue()));
        this.clearWidgets();
        this.contentHeight = 5;
        ISaveableNavigatorData lastData = null;
        for (int i = 0; i < data.size(); ++i) {
            ISaveableNavigatorData d = data.get(i);
            if (lastData != null && lastData.customGroup() != d.customGroup()) {
                this.contentHeight += ((GroupingHeader)this.addRenderableOnly((Renderable)new GroupingHeader(this.x(), this.y() + this.contentHeight, this.width(), (Component)(d.customGroup() == null ? TextUtils.empty() : (MutableComponent)d.customGroup().getSecond()).m_130940_(ChatFormatting.BOLD)))).height();
            }
            if (lastData == null || lastData.dayOrderValue() != d.dayOrderValue()) {
                long worldTime = DragonLib.getCurrentWorldTime();
                long dayDiff = d.dayOrderValue() - (worldTime + 6000L) / 24000L;
                MutableComponent text = d.timeOrderValue() < worldTime ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_the_past") : (dayDiff == 0L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.today") : (dayDiff == 1L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.tomorrow") : TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_days", (Object[])new Object[]{dayDiff})));
                this.contentHeight += ((GroupingHeader)this.addRenderableOnly((Renderable)new GroupingHeader(this.x(), this.y() + this.contentHeight, this.width(), (Component)text))).height();
            }
            lastData = d;
            SavedRouteWidget widget = new SavedRouteWidget(this, this.x(), this.y() + this.contentHeight, d);
            this.addRenderableWidget((GuiEventListener)widget);
            widget.set_x(this.x() + this.width() / 2 - widget.width() / 2);
            this.contentHeight += widget.height() + 3;
        }
        this.contentHeight += 10;
        this.scrollBar.updateMaxScroll(this.contentHeight);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.m_6702_().isEmpty()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + this.width() / 2), (int)(this.y() + this.height() / 2), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.empty_list"), (int)-2368549, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    private static final class GroupingHeader
    extends DLRenderable {
        private static final int HEIGHT = 24;
        private final Component text;

        public GroupingHeader(int x, int y, int width, Component text) {
            super(x, y, width, 24);
            this.text = text == null ? TextUtils.empty() : text;
        }

        public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.x() + 10;
            int n2 = this.y() + this.height() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            GuiUtils.drawString((Graphics)graphics, (Font)font, (int)n, (int)(n2 - 9 / 2), (FormattedText)this.text, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)true);
        }
    }
}

