/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.gui.widgets.SavedRoutesViewer;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.data.ISaveableNavigatorData;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SavedRouteWidget
extends DLButton {
    public static final int WIDTH = 180;
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private static final int DISPLAY_WIDTH = 160;
    private final ISaveableNavigatorData data;
    private final MutableComponent transferText = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final MutableComponent connectionInPast = ELanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = ELanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final MutableComponent textShowDetails = TextUtils.translate((String)"gui.createrailwaysnavigator.saved_route_widget.show_details");
    private final MutableComponent textRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.remove");
    private final MutableComponent textShare = TextUtils.translate((String)"gui.createrailwaysnavigator.saved_route_widget.share");
    private final MutableComponent textShowNotifications = TextUtils.translate((String)"gui.createrailwaysnavigator.saved_route_widget.notifications");

    public SavedRouteWidget(SavedRoutesViewer parent, int x, int y, ISaveableNavigatorData data) {
        super(x, y, 180, 50, (Component)TextUtils.empty(), b -> SavedRouteWidget.clickAction(parent, data));
        this.data = data;
        this.set_height(30 + data.getOverviewData().stream().mapToInt(a -> (int)((float)Math.max(12, ClientWrapper.getTextBlockHeight(this.font, a.text(), 213)) * 0.75f)).sum());
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)this), () -> {
            ClientRoute route;
            return new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)this.textShowDetails, Sprite.empty(), true, b -> this.f_93717_.m_93750_((Button)b), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((Component)this.textRemove, Sprite.empty(), true, b -> {
                SavedRoutesManager.removeRoute((ClientRoute)data);
                SavedRoutesManager.push(true, null);
                parent.displayRoutes(SavedRoutesManager.getAllSavedRoutes());
            }, null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((Component)this.textShowNotifications, data instanceof ClientRoute && (route = (ClientRoute)data).shouldShowNotifications() ? GuiIcons.CHECKMARK.getAsSprite(8, 8) : Sprite.empty(), data instanceof Route, b -> {
                if (data instanceof ClientRoute) {
                    ClientRoute route;
                    route.setShowNotifications(!(route = (ClientRoute)data).shouldShowNotifications());
                }
            }, null));
        }));
    }

    private static void clickAction(SavedRoutesViewer parent, ISaveableNavigatorData data) {
        if (data instanceof ClientRoute) {
            ClientRoute route = (ClientRoute)data;
            Minecraft.m_91087_().m_91152_((Screen)new RouteDetailsScreen(parent.getParent(), route));
        }
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, this.x() + 6, this.y() + 16, this.width() - 12 - this.data.getTitle().icon().getWidth());
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 6), (int)(this.y() + 5), (FormattedText)this.data.getTitle().text(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.data.getTitle().icon().render(graphics, this.x() + this.width() - this.data.getTitle().icon().getWidth() - 3, this.y() + 3);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)(this.x() + 10), (float)(this.y() + 20), 0.0f);
        for (ISaveableNavigatorData.SaveableNavigatorDataLine line : this.data.getOverviewData()) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(0.75f, 0.75f, 1.0f);
            line.icon().render(graphics, 0, -2);
            int height = (int)((float)ClientWrapper.renderMultilineLabelSafe(graphics, 21, 2, this.font, line.text(), 213, -1) * 0.75f);
            graphics.poseStack().m_85849_();
            graphics.poseStack().m_252880_(0.0f, (float)Math.max(9, height + 4), 0.0f);
        }
        graphics.poseStack().m_85849_();
    }
}

