/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.widgets.RouteWidget;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.ScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.List;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;

public class RouteViewer
extends ScrollableWidgetContainer {
    private final Screen parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;

    public RouteViewer(Screen parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.updateMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public Screen getParent() {
        return this.parent;
    }

    public void displayRoutes(List<ClientRoute> routes) {
        this.clearWidgets();
        this.contentHeight = 5;
        for (int i = 0; i < routes.size(); ++i) {
            RouteWidget widget = new RouteWidget(this, routes.get(i), this.x + 10, this.y + this.contentHeight);
            this.addRenderableWidget((GuiEventListener)widget);
            this.contentHeight += 57;
        }
        this.contentHeight += 2;
        this.scrollBar.updateMaxScroll(this.contentHeight);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public void clear() {
        this.clearWidgets();
    }
}

