/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class WelcomePage
extends AbstractRouteDetailsPage {
    private static final String keyDepartureIn = "gui.createrailwaysnavigator.route_details.departure";
    private static final String keyTimeNow = "gui.createrailwaysnavigator.time.now";
    private static final String keyTransferCount = "gui.createrailwaysnavigator.navigator.route_entry.transfer";

    public WelcomePage(ClientRoute route) {
        super(route);
    }

    @Override
    public boolean isImportant() {
        return true;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        int y = 16;
        RouteOverviewPage.renderStation(graphics, -4, this.width(), this.font, this.route.getStart(), RouteOverviewPage.RoutePathIcons.START, true, false);
        GuiUtils.fill((Graphics)graphics, (int)0, (int)y, (int)this.width(), (int)1, (int)-2368549);
        ModGuiIcons.TIME.render(graphics, 5, y + 3);
        long time = this.route.getCurrentPart().departureIn();
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)26, (int)(y + 3 + 8 - 9 / 2), (FormattedText)ELanguage.translate(keyDepartureIn).m_130946_(" ").m_7220_((Component)(time > 0L ? TextUtils.text((String)TimeUtils.parseDurationShort((long)((int)time))) : ELanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        y += 21;
        int detailsLineHeight = 12;
        ClientTrainStop endStation = this.route.getLastClientPart().getLastClientStop();
        MutableComponent platformText = TextUtils.text((String)endStation.getRealTimeStationTag().info().platform());
        int platformTextWidth = this.font.m_92852_((FormattedText)platformText);
        int maxStationNameWidth = this.width() - platformTextWidth - 10 - 5;
        MutableComponent stationText = TextUtils.text((String)ModUtils.formatTime(endStation.getRoundedRealTimeArrivalTime(), false)).m_7220_((Component)TextUtils.text((String)(" " + endStation.getClientTag().tagName())));
        if (this.font.m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.font.m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        Objects.requireNonNull(this.font);
        ModGuiIcons.TARGET.render(graphics, 5, y + 9 / 2 - 8);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)26, (int)y, (FormattedText)stationText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.width() - 5), (int)y, (FormattedText)platformText, (int)(endStation.isStationInfoChanged() ? -48574 : -2368549), (EAlignment)EAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.font);
        ModGuiIcons.INFO.render(graphics, 5, y + 12 + 9 / 2 - 8);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)26, (int)(y + 12), (FormattedText)TextUtils.text((String)String.format("%s %s | %s", this.route.getTransferCount(), ELanguage.translate(keyTransferCount).getString(), TimeUtils.parseDurationShort((long)((int)this.route.travelTime())))), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
    }
}

