/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TransferPage
extends AbstractRouteDetailsPage {
    private static final String keyScheduleTransfer = "gui.createrailwaysnavigator.route_overview.schedule_transfer";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyTimeNow = "gui.createrailwaysnavigator.time.now";
    private final TransferConnection connection;
    private MultiLineLabel messageLabel;

    public TransferPage(ClientRoute route, TransferConnection connection) {
        super(route);
        this.connection = connection;
        String terminus = connection.getDepartureStation().getDisplayTitle();
        StationTag.StationInfo info = connection.getDepartureStation().getRealTimeStationTag().info();
        this.messageLabel = MultiLineLabel.m_94341_((Font)this.font, (FormattedText)(info.platform() == null || info.platform().isBlank() ? ELanguage.translate(keyTransfer, connection.getDepartureStation().getTrainName(), terminus) : ELanguage.translate(keyTransferWithPlatform, connection.getDepartureStation().getTrainName(), terminus, info.platform())), (int)(this.width - 31));
    }

    @Override
    public boolean isImportant() {
        return true;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        int y = 0;
        RouteOverviewPage.renderStation(graphics, -4, this.width(), this.font, this.connection.getDepartureStation(), RouteOverviewPage.RoutePathIcons.START, true, this.connection.isConnectionMissed());
        GuiUtils.fill((Graphics)graphics, (int)0, (int)(y += 16), (int)this.width(), (int)1, (int)-2368549);
        ModGuiIcons.WALK.render(graphics, 5, y + 3);
        long transferTime = this.connection.getDepartureStation().getRealTimeDepartureTime() - DragonLib.getCurrentWorldTime();
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)26, (int)(y + 3 + 8 - 9 / 2), (FormattedText)ELanguage.translate(keyScheduleTransfer).m_130946_(" ").m_7220_((Component)(transferTime > 0L ? TextUtils.text((String)TimeUtils.parseDurationShort((long)((int)transferTime))) : ELanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiGraphics guiGraphics = graphics.graphics();
        Objects.requireNonNull(this.font);
        this.messageLabel.m_6508_(guiGraphics, 26, y += 21, 9, -2368549);
    }
}

