/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CreateDynamicWidgets {
    private static final int BORDER_HEIGHT = 2;
    private static final int TEXTBOX_HEIGHT = 18;
    private static final int COLOR_BORDER = -13027015;
    private static final int COLOR_3D_SHADOW = -13158601;
    private static final int COLOR_3D_HIGHLIGHT = -7631989;
    private static final int COLOR_3D_NEUTRAL = -9145228;
    private static final int COLOR_TEXTBOX_3D_SHADOW = -13158601;
    private static final int COLOR_TEXTBOX_3D_LIGHT = -1;
    private static final int COLOR_TEXTBOX_3D_NEUTRAL = -9145228;
    private static final int COLOR_TEXTBOX_COLOR_BG = -6052957;
    private static final int COLOR_TEXTBOX_COLOR_ACCENT = -7631989;

    public static void renderWidgetInner(Graphics graphics, int x, int y, int w, int h, int color) {
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)w, (int)h, (int)color);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)1, (int)h, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)y, (int)1, (int)h, (int)-13027015);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)h, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 2), (int)y, (int)1, (int)h, (int)-13027015);
    }

    public static void renderWidgetInner(Graphics graphics, int x, int y, int w, int h, ColorShade color) {
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y, w, h, color.getColor());
    }

    public static void renderWidgetTopBorder(Graphics graphics, int x, int y, int w) {
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)y, (int)(w - 2), (int)1, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + 1), (int)w, (int)1, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)(y + 1), (int)(w - 2), (int)1, (int)-13027015);
    }

    public static void renderWidgetBottomBorder(Graphics graphics, int x, int y, int w) {
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)w, (int)1, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)(y + 1), (int)(w - 2), (int)1, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)y, (int)(w - 2), (int)1, (int)-13027015);
    }

    public static void renderSingleShadeWidget(Graphics graphics, int x, int y, int w, int h, int color) {
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y + 2, w, h - 4, color);
        CreateDynamicWidgets.renderWidgetTopBorder(graphics, x, y, w);
        CreateDynamicWidgets.renderWidgetBottomBorder(graphics, x, y + h - 2, w);
    }

    public static void renderSingleShadeWidget(Graphics graphics, int x, int y, int w, int h, ColorShade color) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, x, y, w, h, color.getColor());
    }

    public static void renderDuoShadeWidget(Graphics graphics, int x, int y, int w, int h1, int color1, int h2, int color2) {
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y + 2, w, h1 - 2, color1);
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y + h1, w, h2 - 2, color2);
        CreateDynamicWidgets.renderWidgetTopBorder(graphics, x, y, w);
        CreateDynamicWidgets.renderWidgetBottomBorder(graphics, x, y + h1 + h2 - 2, w);
    }

    public static void renderDuoShadeWidget(Graphics graphics, int x, int y, int w, int h1, ColorShade color1, int h2, ColorShade color2) {
        CreateDynamicWidgets.renderDuoShadeWidget(graphics, x, y, w, h1, color1.getColor(), h2, color2.getColor());
    }

    public static void renderTextSlotOverlay(Graphics graphics, int x, int y, int w, int h) {
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)w, (int)1, (int)-13158601);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + h - 1), (int)w, (int)1, (int)-7631989);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + h - 1), (int)1, (int)1, (int)-9145228);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 1), (int)(y + h - 1), (int)1, (int)1, (int)-9145228);
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)(y + 2), (int)1, (int)1, (int)-13158601);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 2), (int)(y + 2), (int)1, (int)1, (int)-9145228);
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)(y + h - 3), (int)1, (int)1, (int)-9145228);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 2), (int)(y + h - 3), (int)1, (int)1, (int)-7631989);
    }

    public static void renderTextBox(Graphics graphics, int x, int y, int w) {
        int h = 18;
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)w, (int)h, (int)-7631989);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + 2), (int)w, (int)2, (int)-6052957);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + h - 4), (int)w, (int)2, (int)-6052957);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)w, (int)1, (int)-13158601);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + h - 1), (int)w, (int)1, (int)-1);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)1, (int)h, (int)-13158601);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)h, (int)-1);
        GuiUtils.fill((Graphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)1, (int)-9145228);
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + h - 1), (int)1, (int)1, (int)-9145228);
    }

    public static void renderHorizontalSeparator(Graphics graphics, int x, int y, int w) {
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)y, (int)(w - 1), (int)1, (int)ColorShade.LIGHT.getColor());
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + 1), (int)(w - 1), (int)1, (int)-13027015);
    }

    public static void renderContainerBackground(Graphics graphics, int x, int y, int w, int h, ContainerColor color) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)color.res);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)x, (double)y + (double)h, 0.0).m_7421_(0.0f, (float)h / f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x + (double)w, (double)y + (double)h, 0.0).m_7421_((float)w / f, (float)h / f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x + (double)w, (double)y, 0.0).m_7421_((float)w / f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
    }

    protected static void renderNineSliced(Graphics graphics, int x, int y, int w, int h, int u, int v, int textureWidth, int textureHeight, int cornerSliceSize, ResourceLocation location, boolean renderCenter) {
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)x, (int)y, (int)cornerSliceSize, (int)cornerSliceSize, (int)u, (int)v, (int)cornerSliceSize, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + w - cornerSliceSize), (int)y, (int)cornerSliceSize, (int)cornerSliceSize, (int)(u + 1 + cornerSliceSize), (int)v, (int)cornerSliceSize, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)x, (int)(y + h - cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)u, (int)(v + 1 + cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + w - cornerSliceSize), (int)(y + h - cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)(u + 1 + cornerSliceSize), (int)(v + 1 + cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + cornerSliceSize), (int)y, (int)(w - cornerSliceSize * 2), (int)cornerSliceSize, (int)(u + cornerSliceSize), (int)v, (int)1, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + cornerSliceSize), (int)(y + h - cornerSliceSize), (int)(w - cornerSliceSize * 2), (int)cornerSliceSize, (int)(u + cornerSliceSize), (int)(v + 1 + cornerSliceSize), (int)1, (int)cornerSliceSize, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)x, (int)(y + cornerSliceSize), (int)cornerSliceSize, (int)(h - cornerSliceSize * 2), (int)u, (int)(v + cornerSliceSize), (int)cornerSliceSize, (int)1, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + w - cornerSliceSize), (int)(y + cornerSliceSize), (int)cornerSliceSize, (int)(h - cornerSliceSize * 2), (int)(u + 1 + cornerSliceSize), (int)(v + cornerSliceSize), (int)cornerSliceSize, (int)1, (int)textureWidth, (int)textureHeight);
        if (renderCenter) {
            GuiUtils.drawTexture((ResourceLocation)location, (Graphics)graphics, (int)(x + cornerSliceSize), (int)(y + cornerSliceSize), (int)(w - cornerSliceSize * 2), (int)(h - cornerSliceSize * 2), (int)(u + cornerSliceSize), (int)(v + cornerSliceSize), (int)1, (int)1, (int)textureWidth, (int)textureHeight);
        }
    }

    public static void renderContainer(Graphics graphics, int x, int y, int w, int h, ContainerColor color) {
        CreateDynamicWidgets.renderContainerBackground(graphics, x + 2, y + 2, w - 4, h - 4, color);
        CreateDynamicWidgets.renderNineSliced(graphics, x, y, w, h, 0, 7, 64, 64, 2, CRNGui.GUI, false);
    }

    public static void renderTitleBar(Graphics graphics, int x, int y, int w, int h, BarColor color) {
        CreateDynamicWidgets.renderNineSliced(graphics, x, y, w, h, color.u, color.v, 64, 64, 3, CRNGui.GUI, true);
    }

    public static void renderWindow(Graphics graphics, int x, int y, int w, int h, ContainerColor color, BarColor bar, int headerSize, int footerSize, boolean renderContent) {
        CreateDynamicWidgets.renderTitleBar(graphics, x, y, w, headerSize, bar);
        CreateDynamicWidgets.renderTitleBar(graphics, x, y + h - footerSize, w, footerSize, bar);
        if (renderContent) {
            CreateDynamicWidgets.renderContainer(graphics, x + 1, y + headerSize - 1, w - 2, h - headerSize - footerSize + 2, color);
        }
    }

    public static void renderShadow(Graphics graphics, int x, int y, int w, int h) {
        CreateDynamicWidgets.renderNineSliced(graphics, x - 5, y - 5, w + 10, h + 10, 0, 0, 11, 11, 5, new ResourceLocation("createrailwaysnavigator", "textures/gui/shadow.png"), true);
    }

    public static void renderTextHighlighted(Graphics graphics, int x, int y, Font font, Component text, int color) {
        int width = font.m_92852_((FormattedText)text) + 6;
        Objects.requireNonNull(font);
        int height = 9 + 6;
        GuiUtils.fill((Graphics)graphics, (int)x, (int)(y + 1), (int)width, (int)(height - 3), (int)color);
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)y, (int)(width - 2), (int)1, (int)color);
        GuiUtils.fill((Graphics)graphics, (int)(x + 1), (int)(y + height - 2), (int)(width - 2), (int)1, (int)color);
        GuiUtils.drawString((Graphics)graphics, (Font)font, (int)(x + 3), (int)(y + 3), (FormattedText)text, (int)(ModGuiUtils.useWhiteOrBlackForeColor(color) ? -1 : -16777216), (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    public static enum ColorShade {
        LIGHT(-9474193),
        DARK(-11053225);

        private final int color;

        private ColorShade(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum ContainerColor {
        GRAY(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_gray.png")),
        PURPLE(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_purple.png")),
        BLUE(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_blue.png")),
        GOLD(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_gold.png"));

        private ResourceLocation res;

        private ContainerColor(ResourceLocation res) {
            this.res = res;
        }
    }

    public static enum BarColor {
        GRAY(7, 0),
        PURPLE(14, 0),
        GOLD(0, 0);

        private final int u;
        private final int v;

        private BarColor(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }

    public static enum FooterSize {
        DEFAULT(15),
        SMALL(30),
        EXTENDED(36);

        private final int size;

        private FooterSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

