/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.IBERRenderSubtype;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERTrainDestinationDetailed
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private final BERLabel outOfServiceLabel = new BERLabel((Component)ELanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service")).setPos(3.0f, 6.0f).setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);
    private final BERLabel trainLineLabel = new BERLabel().setScale(0.5f, 0.3f).setYScale(0.5f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.IGNORE);
    private final BERLabel destinationLabel = new BERLabel().setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);
    private final BERLabel viaLabel = new BERLabel((Component)ELanguage.translate("gui.createrailwaysnavigator.via").m_130940_(ChatFormatting.ITALIC)).setScale(0.35f, 0.35f).setYScale(0.35f);
    private final BERLabel stopoversLabel = new BERLabel().setScale(0.35f, 0.35f).setYScale(0.35f).setScrollingSpeed(2.0f);

    @Override
    public void renderTick(float deltaTime) {
        this.outOfServiceLabel.renderTick();
        this.trainLineLabel.renderTick();
        this.destinationLabel.renderTick();
        this.viaLabel.renderTick();
        this.stopoversLabel.renderTick();
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isEmpty()) {
            this.outOfServiceLabel.render(graphics, light);
            return;
        }
        this.trainLineLabel.render(graphics, light);
        this.destinationLabel.render(graphics, light);
        this.viaLabel.render(graphics, light);
        this.stopoversLabel.render(graphics, light);
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().isEmpty()) {
            this.outOfServiceLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
            return;
        }
        this.updateContent(blockEntity);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity) {
        this.trainLineLabel.setPos(3.0f, 4.0f).setText((Component)TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()).m_130940_(ChatFormatting.BOLD)).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        this.destinationLabel.setPos(this.trainLineLabel.getTextWidth() + 5.0f, 4.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16) - this.destinationLabel.getX() - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setText((Component)TextUtils.text((String)(blockEntity.getTrainData().getNextStop().isPresent() ? blockEntity.getTrainData().getNextStop().get().getDestination() : ""))).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        this.viaLabel.setPos(3.0f, 10.0f).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        this.stopoversLabel.setPos(Math.max(this.trainLineLabel.getTextWidth(), this.viaLabel.getTextWidth()) + 5.0f, 10.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16) - this.stopoversLabel.getX() - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setText((Component)TextUtils.concat((Component)TextUtils.text((String)" \u25cf "), blockEntity.getTrainData().getStopovers().stream().map(x -> TextUtils.text((String)x.getName())).toList())).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
    }
}

