/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.IBERRenderSubtype;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERPlatformDetailed
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private static final float LINE_HEIGHT = 5.4f;
    private boolean showInfoLine = false;
    private MutableComponent infoLineText = TextUtils.empty();
    private int maxLines = 0;
    private final BERLabel timeLabel = new BERLabel((Component)TextUtils.empty()).setCentered(true).setScale(0.4f, 0.4f).setYScale(0.4f);
    private final BERLabel statusLabel = new BERLabel((Component)TextUtils.empty()).setCentered(true).setScale(0.4f, 0.4f).setYScale(0.4f).setColor(-15658735).setBackground(-1, true).setScrollingSpeed(2.0f);
    private BERLabel[][] lines = new BERLabel[0][];

    @Override
    public void renderTick(float deltaTime) {
        this.timeLabel.renderTick();
        this.statusLabel.renderTick();
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                BERLabel[] line = x[i];
                if (line == null) continue;
                for (int k = 0; k < line.length; ++k) {
                    DLUtils.doIfNotNull((Object)line[k], y -> y.renderTick());
                }
            }
        });
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.setText((Component)ELanguage.translate(keyTime, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), blockEntity.getTimeDisplay() == AdvancedDisplaySource.ETimeDisplay.ETA)));
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        for (int i = 0; i < this.lines.length && i < this.maxLines; ++i) {
            for (int k = 0; k < this.lines[i].length; ++k) {
                if (i >= this.maxLines - 1 && DragonLib.getCurrentWorldTime() % 200L > 100L) {
                    this.timeLabel.render(graphics, light);
                    continue;
                }
                this.lines[i][k].render(graphics, light);
            }
        }
        if (this.lines.length < this.maxLines) {
            this.timeLabel.render(graphics, light);
        }
        if (this.showInfoLine) {
            this.statusLabel.render(graphics, light);
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> x.getStationData().getScheduledArrivalTime() < DragonLib.getCurrentWorldTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue() && (!x.getTrainData().isCancelled() || DragonLib.getCurrentWorldTime() < x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())).toList();
        this.showInfoLine = !preds.isEmpty() && preds.get(0).getStationData().isDepartureDelayed() && preds.get(0).getTrainData().hasStatusInfo();
        this.infoLineText = this.showInfoLine ? TextUtils.concat((Component)TextUtils.text((String)"  +++  "), (Component[])((Component[])preds.stream().limit(this.maxLines).filter(x -> x.getTrainData().hasStatusInfo() && x.getStationData().isDepartureDelayed()).flatMap(x -> {
            ArrayList<Object> content = new ArrayList<Object>();
            if (x.getTrainData().isCancelled()) {
                content.add(ELanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_cancelled", x.getTrainData().getName()));
                return content.stream();
            }
            content.add(ELanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_delayed", x.getTrainData().getName(), TimeUtils.formatToMinutes((long)x.getStationData().getDepartureTimeDeviation())));
            for (TrainStatus.CompiledTrainStatus status : x.getTrainData().getStatus()) {
                content.add(status.text());
            }
            return content.stream();
        }).toArray(Component[]::new))) : TextUtils.empty();
        int defaultMaxLines = blockEntity.getYSizeScaled() * 3 - 1;
        this.maxLines = defaultMaxLines - (this.showInfoLine ? 1 : 0);
        int maxIndices = Math.max(0, Math.min(this.maxLines, preds.size()));
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.lines.length != maxIndices) {
            this.updateLayout(blockEntity, preds, maxIndices);
        }
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.setText((Component)this.infoLineText).setPos(3.0f, (float)(blockEntity.getYSizeScaled() * 16) - 12.0f * this.statusLabel.getYScale() - 2.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds, int maxIndices) {
        this.lines = new BERLabel[maxIndices][];
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.lines[i] = this.createLine(blockEntity, stop, i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.setBackground(0xFF000000 | blockEntity.getColor() & 0xFFFFFF, false);
        this.timeLabel.setPos(3.0f, 3.0f + (float)(Math.min(this.lines.length, this.maxLines) - (this.lines.length < this.maxLines ? 0 : 1)) * 5.4f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        boolean isLast = stop.isLastStop();
        BERLabel[] components = this.lines[index];
        components[LineComponent.TIME.i()].setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), blockEntity.getTimeDisplay() == AdvancedDisplaySource.ETimeDisplay.ETA)));
        components[LineComponent.REAL_TIME.i()].setText((Component)TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(stop.getRealTime(), blockEntity.getTimeDisplay() == AdvancedDisplaySource.ETimeDisplay.ETA) : ""))));
        components[LineComponent.TRAIN_NAME.i()].setText((Component)TextUtils.text((String)stop.getTrainData().getName()));
        components[LineComponent.PLATFORM.i()].setText((Component)(blockEntity.isPlatformFixed() ? TextUtils.empty() : TextUtils.text((String)stop.getStationData().getStationInfo().platform())));
        components[LineComponent.DESTINATION.i()].setText((Component)(isLast ? ELanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        int x = 3;
        components[LineComponent.TIME.i()].setPos((float)x, 3.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.TIME.i()].getTextWidth() + 2.0f));
        components[LineComponent.REAL_TIME.i()].setPos((float)x, 3.0f + (float)index * 5.4f);
        x = (int)((float)x + (components[LineComponent.REAL_TIME.i()].getTextWidth() + 2.0f + (float)(!components[LineComponent.REAL_TIME.i()].getText().getString().isEmpty() ? 2 : 0)));
        BERLabel trainNameLabel = components[LineComponent.TRAIN_NAME.i()].setPos((float)x, 3.0f + (float)index * 5.4f).setMaxWidth((float)blockEntity.getTrainNameWidth(), BERLabel.BoundsHitReaction.SCALE_SCROLL);
        x = (int)((float)x + (trainNameLabel.getMaxWidth() + 2.0f));
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        float platformWidth = platformLabel.getTextWidth();
        platformLabel.setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformWidth, 3.0f + (float)index * 5.4f);
        components[LineComponent.DESTINATION.i()].setPos((float)x, 3.0f + (float)index * 5.4f);
        components[LineComponent.DESTINATION.i()].setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3 - x) - platformWidth - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL);
    }

    private BERLabel[] createLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        BERLabel[] components = new BERLabel[5];
        components[LineComponent.TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        components[LineComponent.REAL_TIME.i()] = new BERLabel().setYScale(0.4f).setMaxWidth(12.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setScale(0.4f, 0.2f).setBackground(0xFF000000 | blockEntity.getColor() & 0xFFFFFF, false).setColor(-15658735);
        components[LineComponent.TRAIN_NAME.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        components[LineComponent.PLATFORM.i()] = new BERLabel().setYScale(0.4f).setScale(0.4f, 0.2f).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        components[LineComponent.DESTINATION.i()] = new BERLabel().setYScale(0.4f).setScrollingSpeed(2.0f).setScale(0.4f, 0.2f).setColor(0xFF000000 | blockEntity.getColor() & 0xFFFFFF);
        return components;
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

