/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.IBERRenderSubtype;
import de.mrjulsen.crn.client.ber.variants.BERError;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class AdvancedDisplaysRegistry {
    private static final Map<EDisplayType, Map<ResourceLocation, Pair<Supplier<IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>>, DisplayTypeInfo>>> displayTypes = new HashMap<EDisplayType, Map<ResourceLocation, Pair<Supplier<IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>>, DisplayTypeInfo>>>();

    public static DisplayTypeResourceKey registerDisplayType(EDisplayType category, ResourceLocation id, Supplier<IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean>> displayRenderer, DisplayTypeInfo info) {
        Map reg = displayTypes.computeIfAbsent(category, x -> new HashMap());
        if (reg.containsKey(id)) {
            throw new IllegalArgumentException("A display type with the id '" + id + "' is already registered!");
        }
        reg.put(id, Pair.of(displayRenderer, (Object)info));
        return new DisplayTypeResourceKey(category, id);
    }

    public static boolean isRegietered(DisplayTypeResourceKey key) {
        return key != null && displayTypes.containsKey((Object)key.category()) && displayTypes.get((Object)key.category()).containsKey(key.id());
    }

    public static IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> getRenderer(DisplayTypeResourceKey key) {
        if (!AdvancedDisplaysRegistry.isRegietered(key)) {
            return new BERError();
        }
        return (IBERRenderSubtype)((Supplier)displayTypes.get((Object)key.category()).get(key.id()).getFirst()).get();
    }

    public static DisplayTypeInfo getInfo(DisplayTypeResourceKey key) {
        if (!AdvancedDisplaysRegistry.isRegietered(key)) {
            return new DisplayTypeInfo(true, $ -> 0);
        }
        return (DisplayTypeInfo)displayTypes.get((Object)key.category()).get(key.id()).getSecond();
    }

    public static Map<ResourceLocation, DisplayTypeInfo> getAllOfType(EDisplayType type) {
        return displayTypes.get((Object)type).entrySet().stream().collect(Collectors.toMap(a -> (ResourceLocation)a.getKey(), b -> (DisplayTypeInfo)((Pair)b.getValue()).getSecond()));
    }

    public static List<DisplayTypeResourceKey> getAllOfTypeAsKey(EDisplayType type) {
        return displayTypes.get((Object)type).entrySet().stream().map(x -> new DisplayTypeResourceKey(type, (ResourceLocation)x.getKey())).toList();
    }

    public static List<ResourceLocation> getAllIdsOfType(EDisplayType type) {
        return displayTypes.get((Object)type).entrySet().stream().map(x -> (ResourceLocation)x.getKey()).toList();
    }

    public record DisplayTypeResourceKey(EDisplayType category, ResourceLocation id) {
        private static final String NBT_CATEGORY = "Category";
        private static final String NBT_ID = "Id";

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean equals(Object arg) {
            if (!(arg instanceof DisplayTypeResourceKey)) return false;
            DisplayTypeResourceKey o = (DisplayTypeResourceKey)arg;
            if (this.category != o.category) return false;
            if (!this.id.equals((Object)o.id)) return false;
            return true;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.category, this.id});
        }

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_(NBT_CATEGORY, this.category().getId());
            nbt.m_128359_(NBT_ID, this.id().toString());
            return nbt;
        }

        public static DisplayTypeResourceKey fromNbt(CompoundTag nbt) {
            return new DisplayTypeResourceKey(EDisplayType.getTypeById(nbt.m_128445_(NBT_CATEGORY)), new ResourceLocation(nbt.m_128461_(NBT_ID)));
        }

        public String getTranslationKey() {
            return "display.createrailwaysnavigator." + this.category().getEnumValueName() + "." + this.id.m_135815_();
        }
    }

    public record DisplayTypeInfo(boolean singleLined, Function<AdvancedDisplayBlockEntity, Integer> platformDisplayTrainsCount) {
    }
}

