/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.HudMod;
import xaero.common.file.SimpleBackup;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.world.connection.MinimapWorldConnectionManager;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.path.XaeroPath;

public class MinimapWorldRootContainer
extends WaypointWorldContainer {
    private boolean configLoaded = false;
    private boolean usingMultiworldDetection = false;
    private boolean ignoreServerLevelId = false;
    private String defaultMultiworldId;
    private boolean teleportationEnabled = true;
    private boolean usingDefaultTeleportCommand = true;
    private String serverTeleportCommandFormat;
    private String serverTeleportCommandRotationFormat;
    private WaypointsSort sortType = WaypointsSort.NONE;
    private boolean sortReversed;
    private boolean ignoreHeightmaps;
    private MinimapWorldConnectionManager subWorldConnections;
    private Map<ResourceKey<Level>, ResourceLocation> dimensionTypeIds;
    private Map<ResourceKey<Level>, DimensionType> dimensionTypes;

    protected MinimapWorldRootContainer(HudMod modMain, MinimapSession session, XaeroPath path) {
        super(modMain, session, path, null);
        this.updateConnectionsField(session.getWaypointSession());
        this.dimensionTypeIds = new HashMap<ResourceKey<Level>, ResourceLocation>();
        this.dimensionTypes = new HashMap<ResourceKey<Level>, DimensionType>();
    }

    public void updateConnectionsField(WaypointSession session) {
        this.subWorldConnections = MinimapWorldConnectionManager.Builder.begin().setMultiplayer(MinimapWorldContainerUtil.isMultiplayer(this.path)).build();
    }

    public boolean isUsingMultiworldDetection() {
        return this.usingMultiworldDetection;
    }

    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.usingMultiworldDetection = usingMultiworldDetection;
    }

    public String getDefaultMultiworldId() {
        return this.defaultMultiworldId;
    }

    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.defaultMultiworldId = defaultMultiworldId;
    }

    public boolean isTeleportationEnabled() {
        return this.teleportationEnabled;
    }

    public void setTeleportationEnabled(boolean teleportation) {
        this.teleportationEnabled = teleportation;
    }

    public boolean isUsingDefaultTeleportCommand() {
        return this.usingDefaultTeleportCommand;
    }

    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.usingDefaultTeleportCommand = usingDefaultTeleportCommand;
    }

    public String getServerTeleportCommandFormat() {
        return this.serverTeleportCommandFormat;
    }

    public String getServerTeleportCommandRotationFormat() {
        return this.serverTeleportCommandRotationFormat;
    }

    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.serverTeleportCommandFormat = serverTeleportCommandFormat;
    }

    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.serverTeleportCommandRotationFormat = serverTeleportCommandRotationFormat;
    }

    public WaypointsSort getSortType() {
        return this.sortType;
    }

    public void setSortType(WaypointsSort sortType) {
        this.sortType = sortType;
    }

    public void toggleSortType() {
        this.sortType = WaypointsSort.values()[(this.sortType.ordinal() + 1) % WaypointsSort.values().length];
    }

    public boolean isSortReversed() {
        return this.sortReversed;
    }

    public void setSortReversed(boolean sortReversed) {
        this.sortReversed = sortReversed;
    }

    public void toggleSortReversed() {
        this.sortReversed = !this.sortReversed;
    }

    public boolean isIgnoreServerLevelId() {
        return this.ignoreServerLevelId;
    }

    public void setIgnoreServerLevelId(boolean ignoreServerLevelId) {
        this.ignoreServerLevelId = ignoreServerLevelId;
    }

    public MinimapWorldConnectionManager getSubWorldConnections() {
        return this.subWorldConnections;
    }

    public boolean isIgnoreHeightmaps() {
        return this.ignoreHeightmaps;
    }

    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.ignoreHeightmaps = ignoreHeightmaps;
    }

    public DimensionType getDimensionType(ResourceKey<Level> dimId) {
        DimensionType dimensionType = this.dimensionTypes.get(dimId);
        if (dimensionType != null) {
            return dimensionType;
        }
        ResourceLocation dimensionTypeId = this.dimensionTypeIds.get(dimId);
        if (dimensionTypeId == null) {
            if (dimId == Level.f_46429_) {
                dimensionTypeId = BuiltinDimensionTypes.f_223543_;
            } else if (dimId == Level.f_46428_) {
                dimensionTypeId = BuiltinDimensionTypes.f_223542_;
            } else if (dimId == Level.f_46430_) {
                dimensionTypeId = BuiltinDimensionTypes.f_223544_;
            } else {
                IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
                if (integratedServer == null) {
                    return null;
                }
                ServerLevel serverLevel = integratedServer.m_129880_(dimId);
                if (serverLevel == null) {
                    return null;
                }
                this.dimensionTypes.put(dimId, serverLevel.m_6042_());
                return serverLevel.m_6042_();
            }
        }
        if ((dimensionType = (DimensionType)Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256787_).m_7745_(dimensionTypeId)) != null) {
            this.dimensionTypes.put(dimId, dimensionType);
        }
        return dimensionType;
    }

    public double getDimensionScale(ResourceKey<Level> dimId) {
        DimensionType dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.f_63859_();
    }

    public void updateDimensionType(ClientLevel level) {
        ResourceKey dimId = level.m_46472_();
        ResourceKey dimTypeId = level.m_220362_();
        DimensionType dimType = level.m_6042_();
        if (Objects.equals(this.dimensionTypeIds.get(dimId), dimTypeId.m_135782_())) {
            return;
        }
        this.dimensionTypes.put((ResourceKey<Level>)dimId, dimType);
        this.dimensionTypeIds.put((ResourceKey<Level>)dimId, dimTypeId.m_135782_());
        this.session.getWorldManagerIO().getRootConfigIO().save(this);
    }

    public void renameOldContainer(XaeroPath containerPath) {
        if (this.subContainers.isEmpty()) {
            return;
        }
        String dimensionPart = containerPath.getAtIndex(1).getLastNode();
        if (this.subContainers.containsKey(dimensionPart)) {
            return;
        }
        ResourceKey<Level> dimId = this.session.getDimensionHelper().getDimensionKeyForDirectoryName(dimensionPart);
        if (dimId == null) {
            return;
        }
        ResourceLocation dimKey = dimId.m_135782_();
        String dimKeyOldValidation = dimKey.m_135815_().replaceAll("[^a-zA-Z0-9_]+", "");
        XaeroPath customWorldPath = this.session.getWorldState().getCustomWorldPath();
        MinimapWorldContainer currentCustomContainer = customWorldPath == null ? null : this.session.getWorldManager().getWorld(customWorldPath).getContainer();
        for (Map.Entry subContainerEntry : this.subContainers.entrySet()) {
            String subKey = (String)subContainerEntry.getKey();
            if (!subKey.equals(dimKeyOldValidation)) continue;
            MinimapWorldContainer dimContainer = (MinimapWorldContainer)subContainerEntry.getValue();
            boolean currentlySelected = currentCustomContainer != null && currentCustomContainer.getPath().isSubOf(dimContainer.getPath());
            this.subContainers.put(dimensionPart, dimContainer);
            this.subContainers.remove(subKey);
            SimpleBackup.moveToBackup(dimContainer.getDirectoryPath());
            dimContainer.setPath(this.path.resolve(dimensionPart));
            if (currentlySelected) {
                this.session.getWorldState().setCustomWorldPath(dimContainer.getPath().resolve(customWorldPath.getSubPath(2)));
            }
            try {
                this.session.getWorldManagerIO().saveWorlds(this);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to rename a dimension! Can't continue.", e);
            }
            MinimapWorldConnectionManager connections = this.getSubWorldConnections();
            connections.renameDimension(subKey, dimensionPart);
            this.session.getWorldManagerIO().getRootConfigIO().save(this);
            return;
        }
    }

    public void confirmConfigLoad() {
        this.configLoaded = true;
    }

    public Iterable<Map.Entry<ResourceKey<Level>, ResourceLocation>> getDimensionTypeIds() {
        return this.dimensionTypeIds.entrySet();
    }

    public void setDimensionTypeId(ResourceKey<Level> dim, ResourceLocation dimType) {
        this.dimensionTypes.remove(dim);
        this.dimensionTypeIds.put(dim, dimType);
    }

    @Override
    public MinimapWorldRootContainer getRoot() {
        return this;
    }

    public boolean isConfigLoaded() {
        return this.configLoaded;
    }

    public static final class Builder {
        private HudMod modMain;
        private MinimapSession session;
        private XaeroPath path;

        private Builder() {
        }

        public Builder setDefault() {
            this.setModMain(null);
            this.setSession(null);
            this.setPath(null);
            return this;
        }

        public Builder setModMain(HudMod modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setSession(MinimapSession session) {
            this.session = session;
            return this;
        }

        public Builder setPath(XaeroPath path) {
            this.path = path;
            return this;
        }

        public MinimapWorldRootContainer build() {
            if (this.modMain == null || this.session == null || this.path == null) {
                throw new IllegalStateException();
            }
            return new WaypointWorldRootContainer(this.modMain, this.session, this.path);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

