/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.HudMod;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;

public class WaypointSharingHandler {
    public static final String WAYPOINT_OLD_SHARE_PREFIX = "xaero_waypoint:";
    public static final String WAYPOINT_ADD_PREFIX = "xaero_waypoint_add:";
    public static final String WAYPOINT_SHARE_PREFIX = "xaero-waypoint:";
    private HudMod modMain;
    private MinimapSession session;
    private Screen parent;
    private Waypoint w;
    private MinimapWorld wWorld;

    public WaypointSharingHandler(HudMod modMain, MinimapSession session) {
        this.modMain = modMain;
        this.session = session;
    }

    @Deprecated
    public void shareWaypoint(Screen parent, Waypoint w, WaypointWorld wWorld) {
        this.shareWaypoint(parent, w, (MinimapWorld)wWorld);
    }

    public void shareWaypoint(Screen parent, Waypoint w, MinimapWorld wWorld) {
        this.parent = parent;
        this.w = w;
        this.wWorld = wWorld;
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(this::confirmResult, (Component)Component.m_237115_((String)"gui.xaero_share_msg1"), (Component)Component.m_237115_((String)"gui.xaero_share_msg2")));
    }

    public void onWaypointReceived(String playerName, String text) {
        boolean newFormat = (text = text.replaceAll("\u00a7.", "")).contains(WAYPOINT_SHARE_PREFIX);
        String sharePrefix = newFormat ? WAYPOINT_SHARE_PREFIX : WAYPOINT_OLD_SHARE_PREFIX;
        String[] args = text.substring(text.indexOf(sharePrefix)).split(":");
        MutableComponent component = null;
        if (args.length < 9) {
            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 0");
        } else {
            if (newFormat) {
                args[1] = this.restoreFormatting(args[1]);
                args[2] = this.restoreFormatting(args[2]);
                if (args.length > 9) {
                    args[9] = this.restoreFormatting(args[9]);
                }
            }
            String waypointName = I18n.m_118938_((String)Waypoint.getStringFromStringSafe(args[1], "^col^"), (Object[])new Object[0]);
            String dimensionName = null;
            if (args.length > 9 && args[9].startsWith("Internal_")) {
                try {
                    ResourceKey<Level> dimId;
                    String details = args[9].substring(9, args[9].lastIndexOf("_")).replace("^col^", ":");
                    dimensionName = details.startsWith("dim%") ? (details.length() == 4 ? I18n.m_118938_((String)"gui.xaero_waypoint_unknown_dimension", (Object[])new Object[0]) : ((dimId = this.session.getDimensionHelper().getDimensionKeyForDirectoryName(details)) == null ? I18n.m_118938_((String)"gui.xaero_waypoint_unknown_dimension", (Object[])new Object[0]) : dimId.m_135782_().m_135815_())) : details;
                }
                catch (IndexOutOfBoundsException details) {
                    // empty catch block
                }
            }
            String newText = I18n.m_118938_((String)(dimensionName != null ? "gui.xaero_waypoint_shared_dimension" : "gui.xaero_waypoint_shared"), (Object[])new Object[]{playerName, waypointName, dimensionName});
            newText = newText.replaceAll("\u00a7r", "\u00a7r\u00a77").replaceAll("\u00a7f", "\u00a77");
            component = Component.m_237113_((String)newText);
            MutableComponent hoverComponent = Component.m_237113_((String)(args[3] + ", " + args[4] + ", " + args[5]));
            StringBuilder addCommandBuilder = new StringBuilder();
            addCommandBuilder.append(WAYPOINT_ADD_PREFIX);
            addCommandBuilder.append(args[1]);
            for (int i = 2; i < args.length; ++i) {
                addCommandBuilder.append(':').append(args[i]);
            }
            String addCommand = addCommandBuilder.toString();
            component.m_6270_(component.m_7383_().m_131157_(ChatFormatting.GRAY).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + addCommand)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent)));
        }
        if (component != null) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(component);
        }
    }

    public void onWaypointAdd(String[] args) {
        String waypointName = Waypoint.getStringFromStringSafe(args[1], "^col^");
        if (waypointName.length() < 1 || waypointName.length() > 32) {
            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 1");
            return;
        }
        String waypointSymbol = Waypoint.getStringFromStringSafe(args[2], "^col^");
        if (waypointSymbol.length() < 1 || waypointSymbol.length() > 3) {
            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 2");
            return;
        }
        try {
            if (this.session.getWorldState().getAutoWorldPath() == null) {
                MinimapLogs.LOGGER.info("Can't add a waypoint at this time!");
                return;
            }
            boolean yIsIncluded = !args[4].equals("~");
            int x = Integer.parseInt(args[3]);
            int y = yIsIncluded ? Integer.parseInt(args[4]) : 0;
            int z = Integer.parseInt(args[5]);
            int color = Integer.parseInt(args[6]);
            String yawString = args[8];
            if (yawString.length() > 4) {
                MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 4");
                return;
            }
            int yaw = Integer.parseInt(yawString);
            boolean rotation = args[7].equals("true");
            Waypoint w = new Waypoint(x, y, z, waypointName, waypointSymbol, color, 0, false, yIsIncluded);
            w.setRotation(rotation);
            w.setYaw(yaw);
            XaeroPath externalContainerId = this.session.getWorldManager().getCurrentRootContainer().getPath();
            MinimapWorld externalWorld = this.session.getWorldManager().getCurrentWorld();
            XaeroPath parentContainerId = externalContainerId;
            MinimapWorld currentWorld = externalWorld;
            if (args.length > 9) {
                String worldDetails = args[9];
                if (worldDetails.length() > 9 && worldDetails.startsWith("Internal_")) {
                    String subContainers;
                    int divider = worldDetails.lastIndexOf(95);
                    if (divider < 1 || divider == worldDetails.length() - 1) {
                        MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 5");
                        return;
                    }
                    String worldId = worldDetails.substring(divider + 1);
                    if (!worldId.replaceAll("[^a-zA-Z0-9,\\$-]+", "").equals(worldId)) {
                        MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 7");
                        return;
                    }
                    boolean destinationDimensionExists = true;
                    try {
                        subContainers = worldDetails.substring(9, divider);
                    }
                    catch (IndexOutOfBoundsException eoobe) {
                        subContainers = null;
                    }
                    parentContainerId = this.session.getWorldState().getAutoRootContainerPath();
                    XaeroPath containerId = null;
                    ResourceKey<Level> dimId = null;
                    if (subContainers != null) {
                        String[] subContainersArgs = (subContainers = subContainers.replace("^col^", ":")).split("/");
                        if (subContainersArgs.length > 1) {
                            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 8");
                            return;
                        }
                        for (int i = 0; i < subContainersArgs.length; ++i) {
                            String[] s = subContainersArgs[i];
                            if (!s.isEmpty()) continue;
                            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 11");
                            return;
                        }
                        String dimContainer = subContainersArgs[0];
                        if (!dimContainer.startsWith("dim%")) {
                            if (!dimContainer.replaceAll("[^a-zA-Z0-9_]+", "").equals(dimContainer)) {
                                MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 18");
                                return;
                            }
                            dimId = this.session.getDimensionHelper().findDimensionKeyForOldName(Minecraft.m_91087_().f_91074_, dimContainer);
                        } else {
                            dimId = this.session.getDimensionHelper().getDimensionKeyForDirectoryName(dimContainer);
                        }
                        if (dimId == null) {
                            MinimapLogs.LOGGER.info("Destination dimension doesn't exists! Handling waypoint as external.");
                            parentContainerId = externalContainerId;
                            currentWorld = externalWorld;
                            destinationDimensionExists = false;
                        } else {
                            subContainersArgs[0] = this.session.getDimensionHelper().getDimensionDirectoryName(dimId);
                            containerId = parentContainerId;
                            for (String subContainersArg : subContainersArgs) {
                                containerId = containerId.resolve(subContainersArg);
                            }
                            MinimapWorldRootContainer rootContainer = this.session.getWorldManager().getRootWorldContainer(parentContainerId);
                            rootContainer.renameOldContainer(containerId);
                        }
                    } else {
                        containerId = parentContainerId;
                    }
                    if (destinationDimensionExists) {
                        MinimapWorld autoWorld;
                        MinimapWorldContainer worldContainer = this.session.getWorldManager().getWorldContainer(containerId);
                        if (worldContainer == (autoWorld = this.session.getWorldManager().getAutoWorld()).getContainer()) {
                            worldId = autoWorld.getNode();
                        } else {
                            MinimapWorld firstWorld = worldContainer.getFirstWorldConnectedTo(autoWorld);
                            if (firstWorld == null) {
                                firstWorld = worldContainer.getFirstWorld();
                            }
                            worldId = firstWorld != null ? firstWorld.getNode() : this.session.getWorldStateUpdater().getPotentialWorldNode(dimId, false, this.session);
                        }
                        try {
                            Path securityTest = containerId.applyToFilePath(this.modMain.getMinimapFolder().toFile().getCanonicalFile().toPath()).resolve(worldId + "_1.txt");
                            if (!securityTest.equals(securityTest.toFile().getCanonicalFile().toPath())) {
                                MinimapLogs.LOGGER.info("Dangerously incorrect format of the shared waypoint! Error: 10");
                                return;
                            }
                        }
                        catch (IOException e) {
                            MinimapLogs.LOGGER.error("IO error adding a shared waypoint!", (Throwable)e);
                            return;
                        }
                        if (this.modMain.getSupportMods().worldmap() && MinimapWorldContainerUtil.isMultiplayer(containerId) && dimId != null) {
                            List<String> worldmapMultiworldIds = this.modMain.getSupportMods().worldmapSupport.getMultiworldIds(dimId);
                            for (String mw : worldmapMultiworldIds) {
                                this.session.getWorldManager().addWorld(containerId.resolve(mw));
                            }
                        }
                        currentWorld = this.session.getWorldManager().getWorld(containerId.resolve(worldId));
                    }
                } else if (!worldDetails.equals("External")) {
                    MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 12");
                    return;
                }
            }
            Minecraft.m_91087_().m_91152_((Screen)new GuiAddWaypoint(this.modMain, this.session, null, null, (ArrayList<Waypoint>)Lists.newArrayList((Object[])new Waypoint[]{w}), parentContainerId, currentWorld, currentWorld.getCurrentWaypointSetId(), true));
        }
        catch (NumberFormatException nfe) {
            MinimapLogs.LOGGER.info("Incorrect format of the shared waypoint! Error: 3");
        }
    }

    public void confirmResult(boolean p_confirmResult_1_) {
        if (p_confirmResult_1_) {
            Object worldDetails;
            MinimapWorldRootContainer autoRootContainer;
            MinimapWorldRootContainer rootContainer = this.wWorld.getContainer().getRoot();
            if (rootContainer == (autoRootContainer = this.session.getWorldManager().getAutoWorld().getContainer().getRoot())) {
                Object details;
                XaeroPath containerId = this.wWorld.getContainer().getPath();
                if (containerId.getNodeCount() > 1) {
                    XaeroPath subContainers = containerId.getSubPath(1);
                    String dimKey = subContainers.getRoot().getLastNode();
                    if (dimKey.equals("dim%0")) {
                        dimKey = "overworld";
                    } else if (dimKey.equals("dim%-1")) {
                        dimKey = "the_nether";
                    } else if (dimKey.equals("dim%1")) {
                        dimKey = "the_end";
                    }
                    subContainers = XaeroPath.root(dimKey).resolve(subContainers.getSubPath(1));
                    details = subContainers.toString().replace(":", "^col^") + "_waypoints";
                } else {
                    details = "waypoints";
                }
                worldDetails = "Internal_" + (String)details;
            } else {
                worldDetails = "External";
            }
            String message = WAYPOINT_SHARE_PREFIX + this.removeFormatting(this.w.getNameSafe("^col^")) + ":" + this.removeFormatting(this.w.getSymbolSafe("^col^")) + ":" + this.w.getX() + ":" + (Serializable)(this.w.isYIncluded() ? Integer.valueOf(this.w.getY()) : "~") + ":" + this.w.getZ() + ":" + this.w.getColor() + ":" + this.w.isRotation() + ":" + this.w.getYaw() + ":" + this.removeFormatting((String)worldDetails);
            Minecraft.m_91087_().f_91065_.m_93076_().m_93783_(message);
            Minecraft.m_91087_().f_91074_.f_108617_.m_246175_(message);
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private String removeFormatting(String s) {
        return s.replace("-", "^min^").replace("_", "-").replace("*", "^ast^");
    }

    private String restoreFormatting(String s) {
        return s.replace("^ast^", "*").replace("-", "_").replace("^min^", "-");
    }
}

