/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.nwtg.cctvcraft.CctvcraftMod;
import net.nwtg.cctvcraft.procedures.SoundBlockMenuAlertButtonProcedure;
import net.nwtg.cctvcraft.procedures.SoundBlockMenuFutureButtonProcedure;
import net.nwtg.cctvcraft.procedures.SoundBlockMenuShortButtonProcedure;
import net.nwtg.cctvcraft.procedures.SoundBlockMenuSifiButtonProcedure;
import net.nwtg.cctvcraft.procedures.SoundBlockMenuSirenButtonProcedure;
import net.nwtg.cctvcraft.world.inventory.SoundBlockMenuMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundBlockMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SoundBlockMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SoundBlockMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SoundBlockMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SoundBlockMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SoundBlockMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SoundBlockMenuMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SoundBlockMenuAlertButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            SoundBlockMenuFutureButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            SoundBlockMenuShortButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            SoundBlockMenuSifiButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            SoundBlockMenuSirenButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(SoundBlockMenuButtonMessage.class, SoundBlockMenuButtonMessage::buffer, SoundBlockMenuButtonMessage::new, SoundBlockMenuButtonMessage::handler);
    }
}

