/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.nwtg.cctvcraft.CctvcraftMod;
import net.nwtg.cctvcraft.procedures.WhenTheMonitorMainMenuButtonIsPressedProcedure;
import net.nwtg.cctvcraft.procedures.WhenTheMonitorRenameButtonIsPressedProcedure;
import net.nwtg.cctvcraft.procedures.WhenTheMonitorViewButtonIsPressedProcedure;
import net.nwtg.cctvcraft.world.inventory.MonitorSwitchesGuiMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MonitorSwitchesGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MonitorSwitchesGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MonitorSwitchesGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MonitorSwitchesGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MonitorSwitchesGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MonitorSwitchesGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MonitorSwitchesGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            WhenTheMonitorMainMenuButtonIsPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            WhenTheMonitorViewButtonIsPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            WhenTheMonitorRenameButtonIsPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(MonitorSwitchesGuiButtonMessage.class, MonitorSwitchesGuiButtonMessage::buffer, MonitorSwitchesGuiButtonMessage::new, MonitorSwitchesGuiButtonMessage::handler);
    }
}

