/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.nwtg.cctvcraft.CctvcraftMod;
import net.nwtg.cctvcraft.procedures.ExitCameraOnKeyPressedProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExitCameraMessage {
    int type;
    int pressedms;

    public ExitCameraMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public ExitCameraMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(ExitCameraMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(ExitCameraMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ExitCameraMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.m_9236_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        if (type == 0) {
            ExitCameraOnKeyPressedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(ExitCameraMessage.class, ExitCameraMessage::buffer, ExitCameraMessage::new, ExitCameraMessage::handler);
    }
}

