/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.nwtg.cctvcraft.CctvcraftMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CctvcraftModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CctvcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.cameraPositionX = message.data.cameraPositionX;
                    variables.cameraPositionY = message.data.cameraPositionY;
                    variables.cameraPositionZ = message.data.cameraPositionZ;
                    variables.cameraDistanceX = message.data.cameraDistanceX;
                    variables.cameraDistanceY = message.data.cameraDistanceY;
                    variables.cameraDistanceZ = message.data.cameraDistanceZ;
                    variables.cameraOverlayLevel = message.data.cameraOverlayLevel;
                    variables.cameraOverlayMode = message.data.cameraOverlayMode;
                    variables.cameraErrorMessage = message.data.cameraErrorMessage;
                    variables.cameraName = message.data.cameraName;
                    variables.cameraNumber = message.data.cameraNumber;
                    variables.cameraZoomLevel = message.data.cameraZoomLevel;
                    variables.cameraViewPositionX = message.data.cameraViewPositionX;
                    variables.cameraViewPositionY = message.data.cameraViewPositionY;
                    variables.cameraViewPositionZ = message.data.cameraViewPositionZ;
                    variables.monitorPositionX = message.data.monitorPositionX;
                    variables.monitorPositionY = message.data.monitorPositionY;
                    variables.monitorPositionZ = message.data.monitorPositionZ;
                    variables.savedGamemode = message.data.savedGamemode;
                    variables.savedPositionX = message.data.savedPositionX;
                    variables.savedPositionY = message.data.savedPositionY;
                    variables.savedPositionZ = message.data.savedPositionZ;
                    variables.savedYawRotation = message.data.savedYawRotation;
                    variables.savedPtichRotation = message.data.savedPtichRotation;
                    variables.IsPlayerViewingCammer = message.data.IsPlayerViewingCammer;
                    variables.isThePlayerFrozen = message.data.isThePlayerFrozen;
                    variables.LocConnections = message.data.LocConnections;
                    variables.cameraViewFrame = message.data.cameraViewFrame;
                    variables.cameraViewFrameTimer = message.data.cameraViewFrameTimer;
                    variables.bloodOverlayTime = message.data.bloodOverlayTime;
                    variables.textFieldName = message.data.textFieldName;
                    variables.cameraPosX1 = message.data.cameraPosX1;
                    variables.cameraPosX2 = message.data.cameraPosX2;
                    variables.cameraPosX3 = message.data.cameraPosX3;
                    variables.cameraPosX4 = message.data.cameraPosX4;
                    variables.cameraPosX5 = message.data.cameraPosX5;
                    variables.cameraPosX6 = message.data.cameraPosX6;
                    variables.cameraPosY1 = message.data.cameraPosY1;
                    variables.cameraPosY2 = message.data.cameraPosY2;
                    variables.cameraPosY3 = message.data.cameraPosY3;
                    variables.cameraPosY4 = message.data.cameraPosY4;
                    variables.cameraPosY5 = message.data.cameraPosY5;
                    variables.cameraPosY6 = message.data.cameraPosY6;
                    variables.cameraPosZ1 = message.data.cameraPosZ1;
                    variables.cameraPosZ2 = message.data.cameraPosZ2;
                    variables.cameraPosZ3 = message.data.cameraPosZ3;
                    variables.cameraPosZ4 = message.data.cameraPosZ4;
                    variables.cameraPosZ5 = message.data.cameraPosZ5;
                    variables.cameraPosZ6 = message.data.cameraPosZ6;
                    variables.monitorLastCamera = message.data.monitorLastCamera;
                    variables.monitorWorld = message.data.monitorWorld;
                    variables.monitorHasCamera1 = message.data.monitorHasCamera1;
                    variables.monitorHasCamera2 = message.data.monitorHasCamera2;
                    variables.monitorHasCamera3 = message.data.monitorHasCamera3;
                    variables.monitorHasCamera4 = message.data.monitorHasCamera4;
                    variables.monitorHasCamera5 = message.data.monitorHasCamera5;
                    variables.monitorHasCamera6 = message.data.monitorHasCamera6;
                    variables.playerName = message.data.playerName;
                    variables.newPlayer = message.data.newPlayer;
                    variables.activeMonitorID = message.data.activeMonitorID;
                    variables.overlayAnimationTimer = message.data.overlayAnimationTimer;
                    variables.playerViewingDrone = message.data.playerViewingDrone;
                    variables.droneDirection = message.data.droneDirection;
                    variables.droneMovementDelay = message.data.droneMovementDelay;
                    variables.droneActionLocked = message.data.droneActionLocked;
                    variables.droneSpeed = message.data.droneSpeed;
                    variables.droneAction = message.data.droneAction;
                    variables.droneEnergy = message.data.droneEnergy;
                    variables.droneWeaponSpeed = message.data.droneWeaponSpeed;
                    variables.droneWeaponTimer = message.data.droneWeaponTimer;
                    variables.droneInventorySlotSelector = message.data.droneInventorySlotSelector;
                    variables.droneInventorySlotItemName = message.data.droneInventorySlotItemName;
                    variables.posX = message.data.posX;
                    variables.posY = message.data.posY;
                    variables.posZ = message.data.posZ;
                    variables.advancementVersionPlayer = message.data.advancementVersionPlayer;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double cameraPositionX = 0.0;
        public double cameraPositionY = 0.0;
        public double cameraPositionZ = 0.0;
        public double cameraDistanceX = 0.0;
        public double cameraDistanceY = 0.0;
        public double cameraDistanceZ = 0.0;
        public double cameraOverlayLevel = 0.0;
        public String cameraOverlayMode = "Defualt";
        public String cameraErrorMessage = "";
        public String cameraName = "";
        public double cameraNumber = 0.0;
        public double cameraZoomLevel = 0.0;
        public double cameraViewPositionX = 0.0;
        public double cameraViewPositionY = 0.0;
        public double cameraViewPositionZ = 0.0;
        public double monitorPositionX = 0.0;
        public double monitorPositionY = 0.0;
        public double monitorPositionZ = 0.0;
        public String savedGamemode = "Survival";
        public double savedPositionX = 0.0;
        public double savedPositionY = 0.0;
        public double savedPositionZ = 0.0;
        public double savedYawRotation = 0.0;
        public double savedPtichRotation = 0.0;
        public boolean IsPlayerViewingCammer = false;
        public boolean isThePlayerFrozen = false;
        public String LocConnections = "Connections";
        public double cameraViewFrame = 0.0;
        public double cameraViewFrameTimer = 0.0;
        public double bloodOverlayTime = 0.0;
        public String textFieldName = "";
        public double cameraPosX1 = 0.0;
        public double cameraPosX2 = 0.0;
        public double cameraPosX3 = 0.0;
        public double cameraPosX4 = 0.0;
        public double cameraPosX5 = 0.0;
        public double cameraPosX6 = 0.0;
        public double cameraPosY1 = 0.0;
        public double cameraPosY2 = 0.0;
        public double cameraPosY3 = 0.0;
        public double cameraPosY4 = 0.0;
        public double cameraPosY5 = 0.0;
        public double cameraPosY6 = 0.0;
        public double cameraPosZ1 = 0.0;
        public double cameraPosZ2 = 0.0;
        public double cameraPosZ3 = 0.0;
        public double cameraPosZ4 = 0.0;
        public double cameraPosZ5 = 0.0;
        public double cameraPosZ6 = 0.0;
        public double monitorLastCamera = 0.0;
        public String monitorWorld = "\"\"";
        public boolean monitorHasCamera1 = false;
        public boolean monitorHasCamera2 = false;
        public boolean monitorHasCamera3 = false;
        public boolean monitorHasCamera4 = false;
        public boolean monitorHasCamera5 = false;
        public boolean monitorHasCamera6 = false;
        public String playerName = "";
        public boolean newPlayer = true;
        public String activeMonitorID = "\"\"";
        public double overlayAnimationTimer = 0.0;
        public boolean playerViewingDrone = false;
        public double droneDirection = 0.0;
        public double droneMovementDelay = 0.0;
        public boolean droneActionLocked = false;
        public double droneSpeed = 5.0;
        public String droneAction = "block.move";
        public double droneEnergy = 0.0;
        public double droneWeaponSpeed = 1.0;
        public double droneWeaponTimer = 10.0;
        public double droneInventorySlotSelector = 0.0;
        public String droneInventorySlotItemName = "";
        public double posX = 0.0;
        public double posY = 0.0;
        public double posZ = 0.0;
        public double advancementVersionPlayer = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("cameraPositionX", this.cameraPositionX);
            nbt.m_128347_("cameraPositionY", this.cameraPositionY);
            nbt.m_128347_("cameraPositionZ", this.cameraPositionZ);
            nbt.m_128347_("cameraDistanceX", this.cameraDistanceX);
            nbt.m_128347_("cameraDistanceY", this.cameraDistanceY);
            nbt.m_128347_("cameraDistanceZ", this.cameraDistanceZ);
            nbt.m_128347_("cameraOverlayLevel", this.cameraOverlayLevel);
            nbt.m_128359_("cameraOverlayMode", this.cameraOverlayMode);
            nbt.m_128359_("cameraErrorMessage", this.cameraErrorMessage);
            nbt.m_128359_("cameraName", this.cameraName);
            nbt.m_128347_("cameraNumber", this.cameraNumber);
            nbt.m_128347_("cameraZoomLevel", this.cameraZoomLevel);
            nbt.m_128347_("cameraViewPositionX", this.cameraViewPositionX);
            nbt.m_128347_("cameraViewPositionY", this.cameraViewPositionY);
            nbt.m_128347_("cameraViewPositionZ", this.cameraViewPositionZ);
            nbt.m_128347_("monitorPositionX", this.monitorPositionX);
            nbt.m_128347_("monitorPositionY", this.monitorPositionY);
            nbt.m_128347_("monitorPositionZ", this.monitorPositionZ);
            nbt.m_128359_("savedGamemode", this.savedGamemode);
            nbt.m_128347_("savedPositionX", this.savedPositionX);
            nbt.m_128347_("savedPositionY", this.savedPositionY);
            nbt.m_128347_("savedPositionZ", this.savedPositionZ);
            nbt.m_128347_("savedYawRotation", this.savedYawRotation);
            nbt.m_128347_("savedPtichRotation", this.savedPtichRotation);
            nbt.m_128379_("IsPlayerViewingCammer", this.IsPlayerViewingCammer);
            nbt.m_128379_("isThePlayerFrozen", this.isThePlayerFrozen);
            nbt.m_128359_("LocConnections", this.LocConnections);
            nbt.m_128347_("cameraViewFrame", this.cameraViewFrame);
            nbt.m_128347_("cameraViewFrameTimer", this.cameraViewFrameTimer);
            nbt.m_128347_("bloodOverlayTime", this.bloodOverlayTime);
            nbt.m_128359_("textFieldName", this.textFieldName);
            nbt.m_128347_("cameraPosX1", this.cameraPosX1);
            nbt.m_128347_("cameraPosX2", this.cameraPosX2);
            nbt.m_128347_("cameraPosX3", this.cameraPosX3);
            nbt.m_128347_("cameraPosX4", this.cameraPosX4);
            nbt.m_128347_("cameraPosX5", this.cameraPosX5);
            nbt.m_128347_("cameraPosX6", this.cameraPosX6);
            nbt.m_128347_("cameraPosY1", this.cameraPosY1);
            nbt.m_128347_("cameraPosY2", this.cameraPosY2);
            nbt.m_128347_("cameraPosY3", this.cameraPosY3);
            nbt.m_128347_("cameraPosY4", this.cameraPosY4);
            nbt.m_128347_("cameraPosY5", this.cameraPosY5);
            nbt.m_128347_("cameraPosY6", this.cameraPosY6);
            nbt.m_128347_("cameraPosZ1", this.cameraPosZ1);
            nbt.m_128347_("cameraPosZ2", this.cameraPosZ2);
            nbt.m_128347_("cameraPosZ3", this.cameraPosZ3);
            nbt.m_128347_("cameraPosZ4", this.cameraPosZ4);
            nbt.m_128347_("cameraPosZ5", this.cameraPosZ5);
            nbt.m_128347_("cameraPosZ6", this.cameraPosZ6);
            nbt.m_128347_("monitorLastCamera", this.monitorLastCamera);
            nbt.m_128359_("monitorWorld", this.monitorWorld);
            nbt.m_128379_("monitorHasCamera1", this.monitorHasCamera1);
            nbt.m_128379_("monitorHasCamera2", this.monitorHasCamera2);
            nbt.m_128379_("monitorHasCamera3", this.monitorHasCamera3);
            nbt.m_128379_("monitorHasCamera4", this.monitorHasCamera4);
            nbt.m_128379_("monitorHasCamera5", this.monitorHasCamera5);
            nbt.m_128379_("monitorHasCamera6", this.monitorHasCamera6);
            nbt.m_128359_("playerName", this.playerName);
            nbt.m_128379_("newPlayer", this.newPlayer);
            nbt.m_128359_("activeMonitorID", this.activeMonitorID);
            nbt.m_128347_("overlayAnimationTimer", this.overlayAnimationTimer);
            nbt.m_128379_("playerViewingDrone", this.playerViewingDrone);
            nbt.m_128347_("droneDirection", this.droneDirection);
            nbt.m_128347_("droneMovementDelay", this.droneMovementDelay);
            nbt.m_128379_("droneActionLocked", this.droneActionLocked);
            nbt.m_128347_("droneSpeed", this.droneSpeed);
            nbt.m_128359_("droneAction", this.droneAction);
            nbt.m_128347_("droneEnergy", this.droneEnergy);
            nbt.m_128347_("droneWeaponSpeed", this.droneWeaponSpeed);
            nbt.m_128347_("droneWeaponTimer", this.droneWeaponTimer);
            nbt.m_128347_("droneInventorySlotSelector", this.droneInventorySlotSelector);
            nbt.m_128359_("droneInventorySlotItemName", this.droneInventorySlotItemName);
            nbt.m_128347_("posX", this.posX);
            nbt.m_128347_("posY", this.posY);
            nbt.m_128347_("posZ", this.posZ);
            nbt.m_128347_("advancementVersionPlayer", this.advancementVersionPlayer);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.cameraPositionX = nbt.m_128459_("cameraPositionX");
            this.cameraPositionY = nbt.m_128459_("cameraPositionY");
            this.cameraPositionZ = nbt.m_128459_("cameraPositionZ");
            this.cameraDistanceX = nbt.m_128459_("cameraDistanceX");
            this.cameraDistanceY = nbt.m_128459_("cameraDistanceY");
            this.cameraDistanceZ = nbt.m_128459_("cameraDistanceZ");
            this.cameraOverlayLevel = nbt.m_128459_("cameraOverlayLevel");
            this.cameraOverlayMode = nbt.m_128461_("cameraOverlayMode");
            this.cameraErrorMessage = nbt.m_128461_("cameraErrorMessage");
            this.cameraName = nbt.m_128461_("cameraName");
            this.cameraNumber = nbt.m_128459_("cameraNumber");
            this.cameraZoomLevel = nbt.m_128459_("cameraZoomLevel");
            this.cameraViewPositionX = nbt.m_128459_("cameraViewPositionX");
            this.cameraViewPositionY = nbt.m_128459_("cameraViewPositionY");
            this.cameraViewPositionZ = nbt.m_128459_("cameraViewPositionZ");
            this.monitorPositionX = nbt.m_128459_("monitorPositionX");
            this.monitorPositionY = nbt.m_128459_("monitorPositionY");
            this.monitorPositionZ = nbt.m_128459_("monitorPositionZ");
            this.savedGamemode = nbt.m_128461_("savedGamemode");
            this.savedPositionX = nbt.m_128459_("savedPositionX");
            this.savedPositionY = nbt.m_128459_("savedPositionY");
            this.savedPositionZ = nbt.m_128459_("savedPositionZ");
            this.savedYawRotation = nbt.m_128459_("savedYawRotation");
            this.savedPtichRotation = nbt.m_128459_("savedPtichRotation");
            this.IsPlayerViewingCammer = nbt.m_128471_("IsPlayerViewingCammer");
            this.isThePlayerFrozen = nbt.m_128471_("isThePlayerFrozen");
            this.LocConnections = nbt.m_128461_("LocConnections");
            this.cameraViewFrame = nbt.m_128459_("cameraViewFrame");
            this.cameraViewFrameTimer = nbt.m_128459_("cameraViewFrameTimer");
            this.bloodOverlayTime = nbt.m_128459_("bloodOverlayTime");
            this.textFieldName = nbt.m_128461_("textFieldName");
            this.cameraPosX1 = nbt.m_128459_("cameraPosX1");
            this.cameraPosX2 = nbt.m_128459_("cameraPosX2");
            this.cameraPosX3 = nbt.m_128459_("cameraPosX3");
            this.cameraPosX4 = nbt.m_128459_("cameraPosX4");
            this.cameraPosX5 = nbt.m_128459_("cameraPosX5");
            this.cameraPosX6 = nbt.m_128459_("cameraPosX6");
            this.cameraPosY1 = nbt.m_128459_("cameraPosY1");
            this.cameraPosY2 = nbt.m_128459_("cameraPosY2");
            this.cameraPosY3 = nbt.m_128459_("cameraPosY3");
            this.cameraPosY4 = nbt.m_128459_("cameraPosY4");
            this.cameraPosY5 = nbt.m_128459_("cameraPosY5");
            this.cameraPosY6 = nbt.m_128459_("cameraPosY6");
            this.cameraPosZ1 = nbt.m_128459_("cameraPosZ1");
            this.cameraPosZ2 = nbt.m_128459_("cameraPosZ2");
            this.cameraPosZ3 = nbt.m_128459_("cameraPosZ3");
            this.cameraPosZ4 = nbt.m_128459_("cameraPosZ4");
            this.cameraPosZ5 = nbt.m_128459_("cameraPosZ5");
            this.cameraPosZ6 = nbt.m_128459_("cameraPosZ6");
            this.monitorLastCamera = nbt.m_128459_("monitorLastCamera");
            this.monitorWorld = nbt.m_128461_("monitorWorld");
            this.monitorHasCamera1 = nbt.m_128471_("monitorHasCamera1");
            this.monitorHasCamera2 = nbt.m_128471_("monitorHasCamera2");
            this.monitorHasCamera3 = nbt.m_128471_("monitorHasCamera3");
            this.monitorHasCamera4 = nbt.m_128471_("monitorHasCamera4");
            this.monitorHasCamera5 = nbt.m_128471_("monitorHasCamera5");
            this.monitorHasCamera6 = nbt.m_128471_("monitorHasCamera6");
            this.playerName = nbt.m_128461_("playerName");
            this.newPlayer = nbt.m_128471_("newPlayer");
            this.activeMonitorID = nbt.m_128461_("activeMonitorID");
            this.overlayAnimationTimer = nbt.m_128459_("overlayAnimationTimer");
            this.playerViewingDrone = nbt.m_128471_("playerViewingDrone");
            this.droneDirection = nbt.m_128459_("droneDirection");
            this.droneMovementDelay = nbt.m_128459_("droneMovementDelay");
            this.droneActionLocked = nbt.m_128471_("droneActionLocked");
            this.droneSpeed = nbt.m_128459_("droneSpeed");
            this.droneAction = nbt.m_128461_("droneAction");
            this.droneEnergy = nbt.m_128459_("droneEnergy");
            this.droneWeaponSpeed = nbt.m_128459_("droneWeaponSpeed");
            this.droneWeaponTimer = nbt.m_128459_("droneWeaponTimer");
            this.droneInventorySlotSelector = nbt.m_128459_("droneInventorySlotSelector");
            this.droneInventorySlotItemName = nbt.m_128461_("droneInventorySlotItemName");
            this.posX = nbt.m_128459_("posX");
            this.posY = nbt.m_128459_("posY");
            this.posZ = nbt.m_128459_("posZ");
            this.advancementVersionPlayer = nbt.m_128459_("advancementVersionPlayer");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("cctvcraft", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "cctvcraft_mapvars";
        public double monitorSoundTimer = 0.0;
        public double maxDistance = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.monitorSoundTimer = nbt.m_128459_("monitorSoundTimer");
            this.maxDistance = nbt.m_128459_("maxDistance");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("monitorSoundTimer", this.monitorSoundTimer);
            nbt.m_128347_("maxDistance", this.maxDistance);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "cctvcraft_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.savedGamemode = original.savedGamemode;
            clone.savedPositionX = original.savedPositionX;
            clone.savedPositionY = original.savedPositionY;
            clone.savedPositionZ = original.savedPositionZ;
            clone.savedYawRotation = original.savedYawRotation;
            clone.savedPtichRotation = original.savedPtichRotation;
            clone.IsPlayerViewingCammer = original.IsPlayerViewingCammer;
            clone.isThePlayerFrozen = original.isThePlayerFrozen;
            clone.LocConnections = original.LocConnections;
            clone.bloodOverlayTime = original.bloodOverlayTime;
            clone.cameraPosX1 = original.cameraPosX1;
            clone.cameraPosX2 = original.cameraPosX2;
            clone.cameraPosX3 = original.cameraPosX3;
            clone.cameraPosX4 = original.cameraPosX4;
            clone.cameraPosX5 = original.cameraPosX5;
            clone.cameraPosX6 = original.cameraPosX6;
            clone.cameraPosY1 = original.cameraPosY1;
            clone.cameraPosY2 = original.cameraPosY2;
            clone.cameraPosY3 = original.cameraPosY3;
            clone.cameraPosY4 = original.cameraPosY4;
            clone.cameraPosY5 = original.cameraPosY5;
            clone.cameraPosY6 = original.cameraPosY6;
            clone.cameraPosZ1 = original.cameraPosZ1;
            clone.cameraPosZ2 = original.cameraPosZ2;
            clone.cameraPosZ3 = original.cameraPosZ3;
            clone.cameraPosZ4 = original.cameraPosZ4;
            clone.cameraPosZ5 = original.cameraPosZ5;
            clone.cameraPosZ6 = original.cameraPosZ6;
            clone.monitorLastCamera = original.monitorLastCamera;
            clone.monitorWorld = original.monitorWorld;
            clone.monitorHasCamera1 = original.monitorHasCamera1;
            clone.monitorHasCamera2 = original.monitorHasCamera2;
            clone.monitorHasCamera3 = original.monitorHasCamera3;
            clone.monitorHasCamera4 = original.monitorHasCamera4;
            clone.monitorHasCamera5 = original.monitorHasCamera5;
            clone.monitorHasCamera6 = original.monitorHasCamera6;
            clone.playerName = original.playerName;
            clone.newPlayer = original.newPlayer;
            clone.activeMonitorID = original.activeMonitorID;
            clone.playerViewingDrone = original.playerViewingDrone;
            clone.droneDirection = original.droneDirection;
            clone.droneMovementDelay = original.droneMovementDelay;
            clone.droneActionLocked = original.droneActionLocked;
            clone.droneSpeed = original.droneSpeed;
            clone.droneAction = original.droneAction;
            clone.droneWeaponSpeed = original.droneWeaponSpeed;
            clone.droneWeaponTimer = original.droneWeaponTimer;
            clone.droneInventorySlotSelector = original.droneInventorySlotSelector;
            clone.droneInventorySlotItemName = original.droneInventorySlotItemName;
            clone.advancementVersionPlayer = original.advancementVersionPlayer;
            if (!event.isWasDeath()) {
                clone.cameraPositionX = original.cameraPositionX;
                clone.cameraPositionY = original.cameraPositionY;
                clone.cameraPositionZ = original.cameraPositionZ;
                clone.cameraDistanceX = original.cameraDistanceX;
                clone.cameraDistanceY = original.cameraDistanceY;
                clone.cameraDistanceZ = original.cameraDistanceZ;
                clone.cameraOverlayLevel = original.cameraOverlayLevel;
                clone.cameraOverlayMode = original.cameraOverlayMode;
                clone.cameraErrorMessage = original.cameraErrorMessage;
                clone.cameraName = original.cameraName;
                clone.cameraNumber = original.cameraNumber;
                clone.cameraZoomLevel = original.cameraZoomLevel;
                clone.cameraViewPositionX = original.cameraViewPositionX;
                clone.cameraViewPositionY = original.cameraViewPositionY;
                clone.cameraViewPositionZ = original.cameraViewPositionZ;
                clone.monitorPositionX = original.monitorPositionX;
                clone.monitorPositionY = original.monitorPositionY;
                clone.monitorPositionZ = original.monitorPositionZ;
                clone.cameraViewFrame = original.cameraViewFrame;
                clone.cameraViewFrameTimer = original.cameraViewFrameTimer;
                clone.textFieldName = original.textFieldName;
                clone.overlayAnimationTimer = original.overlayAnimationTimer;
                clone.droneEnergy = original.droneEnergy;
                clone.posX = original.posX;
                clone.posY = original.posY;
                clone.posZ = original.posZ;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CctvcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

