/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.nwtg.cctvcraft.CctvcraftMod;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreen1ButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreen2ButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreen3ButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreen4ButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreen5ButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenAButtonClickedProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenAllOffButtonActionProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenAllOnButtonActionProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenNextSlotButtonProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenOverrideOffButtonScriptProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenOverrideOnButtonScriptProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenPreviousSlotButtonProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenSingleOffButtonActionProcedure;
import net.nwtg.cctvcraft.procedures.AlarmSystemScreenSingleOnButtonActionProcedure;
import net.nwtg.cctvcraft.world.inventory.AlarmSystemScreenMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AlarmSystemScreenButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public AlarmSystemScreenButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public AlarmSystemScreenButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(AlarmSystemScreenButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(AlarmSystemScreenButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            AlarmSystemScreenButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = AlarmSystemScreenMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AlarmSystemScreenAllOnButtonActionProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            AlarmSystemScreenAllOffButtonActionProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            AlarmSystemScreenSingleOnButtonActionProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            AlarmSystemScreenSingleOffButtonActionProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            AlarmSystemScreenPreviousSlotButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            AlarmSystemScreenNextSlotButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            AlarmSystemScreen1ButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            AlarmSystemScreen2ButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            AlarmSystemScreen3ButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            AlarmSystemScreen4ButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            AlarmSystemScreen5ButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 11) {
            AlarmSystemScreenAButtonClickedProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 12) {
            AlarmSystemScreenOverrideOffButtonScriptProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 13) {
            AlarmSystemScreenOverrideOnButtonScriptProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CctvcraftMod.addNetworkMessage(AlarmSystemScreenButtonMessage.class, AlarmSystemScreenButtonMessage::buffer, AlarmSystemScreenButtonMessage::new, AlarmSystemScreenButtonMessage::handler);
    }
}

