/*
 * Decompiled with CFR 0.152.
 */
package net.nwtg.cctvcraft;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.nwtg.cctvcraft.init.CctvcraftModBlockEntities;
import net.nwtg.cctvcraft.init.CctvcraftModBlocks;
import net.nwtg.cctvcraft.init.CctvcraftModEntities;
import net.nwtg.cctvcraft.init.CctvcraftModFeatures;
import net.nwtg.cctvcraft.init.CctvcraftModItems;
import net.nwtg.cctvcraft.init.CctvcraftModMenus;
import net.nwtg.cctvcraft.init.CctvcraftModMobEffects;
import net.nwtg.cctvcraft.init.CctvcraftModParticleTypes;
import net.nwtg.cctvcraft.init.CctvcraftModSounds;
import net.nwtg.cctvcraft.init.CctvcraftModTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cctvcraft")
public class CctvcraftMod {
    public static final Logger LOGGER = LogManager.getLogger(CctvcraftMod.class);
    public static final String MODID = "cctvcraft";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("cctvcraft", "cctvcraft"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CctvcraftMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CctvcraftModSounds.REGISTRY.register(bus);
        CctvcraftModBlocks.REGISTRY.register(bus);
        CctvcraftModBlockEntities.REGISTRY.register(bus);
        CctvcraftModItems.REGISTRY.register(bus);
        CctvcraftModEntities.REGISTRY.register(bus);
        CctvcraftModTabs.REGISTRY.register(bus);
        CctvcraftModFeatures.REGISTRY.register(bus);
        CctvcraftModMobEffects.REGISTRY.register(bus);
        CctvcraftModParticleTypes.REGISTRY.register(bus);
        CctvcraftModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

