/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.neat.NeatConfig;

public class NeatForgeConfig {
    public static void init() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ForgeNeatConfig::new);
        NeatConfig.instance = (NeatConfig.ConfigAccess)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
    }

    private static class ForgeNeatConfig
    implements NeatConfig.ConfigAccess {
        private final ForgeConfigSpec.ConfigValue<Integer> maxDistance;
        private final ForgeConfigSpec.ConfigValue<Integer> maxDistanceWithoutLineOfSight;
        private final ForgeConfigSpec.ConfigValue<Boolean> renderInF1;
        private final ForgeConfigSpec.ConfigValue<Double> heightAbove;
        private final ForgeConfigSpec.ConfigValue<Boolean> drawBackground;
        private final ForgeConfigSpec.ConfigValue<Integer> backgroundPadding;
        private final ForgeConfigSpec.ConfigValue<Integer> backgroundHeight;
        private final ForgeConfigSpec.ConfigValue<Integer> barHeight;
        private final ForgeConfigSpec.ConfigValue<Integer> plateSize;
        private final ForgeConfigSpec.ConfigValue<Integer> plateSizeBoss;
        private final ForgeConfigSpec.ConfigValue<Boolean> showAttributes;
        private final ForgeConfigSpec.ConfigValue<Boolean> showArmor;
        private final ForgeConfigSpec.ConfigValue<Boolean> groupArmor;
        private final ForgeConfigSpec.ConfigValue<Boolean> colorByType;
        private final ForgeConfigSpec.ConfigValue<String> textColor;
        private final ForgeConfigSpec.ConfigValue<Integer> hpTextHeight;
        private final ForgeConfigSpec.ConfigValue<Boolean> showMaxHP;
        private final ForgeConfigSpec.ConfigValue<Boolean> showCurrentHP;
        private final ForgeConfigSpec.ConfigValue<Boolean> showPercentage;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnPassive;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnHostile;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnPlayers;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnBosses;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnlyFocused;
        private final ForgeConfigSpec.ConfigValue<Boolean> showFullHealth;
        private final ForgeConfigSpec.ConfigValue<Boolean> enableDebugInfo;
        private final ForgeConfigSpec.ConfigValue<Boolean> showEntityName;
        private final ForgeConfigSpec.ConfigValue<Boolean> disableNameTag;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

        public ForgeNeatConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.maxDistance = builder.define("Max Distance", (Object)24);
            this.maxDistanceWithoutLineOfSight = builder.define("Max Distance Without Line of Sight", (Object)8);
            this.renderInF1 = builder.define("Render with Interface Disabled (F1)", false);
            this.heightAbove = builder.define("Height Above Mob", (Object)0.6);
            this.drawBackground = builder.define("Draw Background", true);
            this.backgroundPadding = builder.define("Background Padding", (Object)2);
            this.backgroundHeight = builder.define("Background Height", (Object)6);
            this.barHeight = builder.define("Health Bar Height", (Object)4);
            this.plateSize = builder.define("Plate Size", (Object)25);
            this.plateSizeBoss = builder.define("Plate Size (Boss)", (Object)50);
            this.showAttributes = builder.define("Show Attributes", true);
            this.showArmor = builder.define("Show Armor", true);
            this.groupArmor = builder.define("Group Armor (condense 5 iron icons into 1 diamond icon)", true);
            this.colorByType = builder.define("Color Health Bar by Type (instead of health percentage)", false);
            this.textColor = builder.comment("Text color in hex code format").define("text_color", (Object)"FFFFFF");
            this.hpTextHeight = builder.define("HP Text Height", (Object)14);
            this.showMaxHP = builder.define("Show Max HP", true);
            this.showCurrentHP = builder.define("Show Current HP", true);
            this.showPercentage = builder.define("Show HP Percentage", true);
            this.showOnPassive = builder.comment("Whether bars on passive mobs should be shown").define("showOnPassive", true);
            this.showOnHostile = builder.comment("Whether bars on hostile mobs should be shown (does not include bosses)").define("showOnHostile", true);
            this.showOnPlayers = builder.define("Display on Players", true);
            this.showOnBosses = builder.define("Display on Bosses", true);
            this.showOnlyFocused = builder.define("Only show the health bar for the entity looked at", false);
            this.showFullHealth = builder.define("Show entities with full health", true);
            this.enableDebugInfo = builder.define("Show Debug Info with F3", true);
            this.showEntityName = builder.define("show_entity_name", true);
            this.disableNameTag = builder.comment("Disables the rendering of the vanilla name tag").define("disable_name_tag", false);
            this.blacklist = builder.comment("Blacklist uses entity IDs, not their display names. Use F3 to see them in the Neat bar.").defineList("Blacklist", NeatConfig.DEFAULT_DISABLED, a -> true);
            builder.pop();
        }

        @Override
        public int maxDistance() {
            return (Integer)this.maxDistance.get();
        }

        @Override
        public int maxDistanceWithoutLineOfSight() {
            return (Integer)this.maxDistanceWithoutLineOfSight.get();
        }

        @Override
        public boolean renderInF1() {
            return (Boolean)this.renderInF1.get();
        }

        @Override
        public double heightAbove() {
            return (Double)this.heightAbove.get();
        }

        @Override
        public boolean drawBackground() {
            return (Boolean)this.drawBackground.get();
        }

        @Override
        public int backgroundPadding() {
            return (Integer)this.backgroundPadding.get();
        }

        @Override
        public int backgroundHeight() {
            return (Integer)this.backgroundHeight.get();
        }

        @Override
        public int barHeight() {
            return (Integer)this.barHeight.get();
        }

        @Override
        public int plateSize() {
            return (Integer)this.plateSize.get();
        }

        @Override
        public int plateSizeBoss() {
            return (Integer)this.plateSizeBoss.get();
        }

        @Override
        public boolean showAttributes() {
            return (Boolean)this.showAttributes.get();
        }

        @Override
        public boolean showArmor() {
            return (Boolean)this.showArmor.get();
        }

        @Override
        public boolean groupArmor() {
            return (Boolean)this.groupArmor.get();
        }

        @Override
        public boolean colorByType() {
            return (Boolean)this.colorByType.get();
        }

        @Override
        public String textColor() {
            return (String)this.textColor.get();
        }

        @Override
        public int hpTextHeight() {
            return (Integer)this.hpTextHeight.get();
        }

        @Override
        public boolean showMaxHP() {
            return (Boolean)this.showMaxHP.get();
        }

        @Override
        public boolean showCurrentHP() {
            return (Boolean)this.showCurrentHP.get();
        }

        @Override
        public boolean showPercentage() {
            return (Boolean)this.showPercentage.get();
        }

        @Override
        public boolean showOnPassive() {
            return (Boolean)this.showOnPassive.get();
        }

        @Override
        public boolean showOnHostile() {
            return (Boolean)this.showOnHostile.get();
        }

        @Override
        public boolean showOnPlayers() {
            return (Boolean)this.showOnPlayers.get();
        }

        @Override
        public boolean showOnBosses() {
            return (Boolean)this.showOnBosses.get();
        }

        @Override
        public boolean showOnlyFocused() {
            return (Boolean)this.showOnlyFocused.get();
        }

        @Override
        public boolean showFullHealth() {
            return (Boolean)this.showFullHealth.get();
        }

        @Override
        public boolean enableDebugInfo() {
            return (Boolean)this.enableDebugInfo.get();
        }

        @Override
        public boolean showEntityName() {
            return (Boolean)this.showEntityName.get();
        }

        @Override
        public boolean disableNameTag() {
            return (Boolean)this.disableNameTag.get();
        }

        @Override
        public List<String> blacklist() {
            return (List)this.blacklist.get();
        }
    }
}

